<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Http\Helpers;
use App\Providers\RouteServiceProvider;
use Illuminate\Support\Facades\Log;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Routing\Redirector;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Lacasts\Flash\Flash;
use App\Models\User;
use App\Models\Acceso_empresa;
use App\Models\Empresa;

class LoginController extends Controller
{
    /*-----------------------------------------------------------------------------
    | Login Controller
    |-------------------------------------------------------------------------------
    | Este controlador maneja la autenticación de los usuarios para la aplicación y
    | los redirige a su pantalla de inicio. El controlador utiliza un rasgo para 
    | proporcionar convenientemente su funcionalidad a sus aplicaciones.
    */

    use AuthenticatesUsers;

    /**  Where to redirect users after login.
     *   @var string
     **/
    protected $redirectTo = RouteServiceProvider::HOME;

    /** Create a new controller instance.
     *
     *  @return void
     **/
    
    // public function __construct()
    // {
    //     $this->middleware('guest')->except('logout');
    // }

    public function login(Request $request, Redirector $redirect)
    {
        if (is_null($request->nick)) {
            return view('auth.login');
        } else {
            $user = User::select("u.idusuario",
                                "u.nick",
                                "u.nombre",
                                "e.nombre as empresa",
                                "u.idempresa",
                                "u.contrasena",
                                "u.estado")
                        ->from("usuario as u")
                        ->join('empresa as e', 'u.idempresa', '=', 'e.idempresa')
                        ->where('nick', $request->nick)
                        ->first();
                        // dd($user);
            if (!is_null($user)) {
                if ($user->estado=='ACTIVO') {
                    // $pass=Hash::check($request->contrasena,$user->contrasena);
                    //dd($pass);    
                    if (Hash::check($request->contrasena,$user->contrasena)== 'true') {
                        $conectado = Auth::login($user); // esto para q sirve?
                        $request->session()->regenerate(); // esto para sirve?
                        // Reiniciar el campo de intentos fallidos
                        $intentos = User::where('idusuario', $user->idusuario)->update(['intento_fallido' => 0]);
                        // Lista de Empresas a las que puede acceder el Usuario logueado
                        $acceso_empresas=Acceso_empresa::where('idusuario', $user->idusuario)
                        ->pluck('idempresa')->toarray();
                        // Evalua si el usuario posee empresas de acceso - pasa solo si posee
                        $cant=count($acceso_empresas);
                        if($cant==0){
                            return redirect()->back()->with('mensaje','El Usuario no posee Empresas de Acceso...!');
                        }else{
                            $empresas=Empresa::whereIn('idempresa', $acceso_empresas)
                            ->orderBy('nombre', 'asc')
                            ->get();
                            /*---------------------------------*/
                            $datoslogin = [
                                "nombre" => $user->nombre,
                                "nick" => $user->nick,
                                "contrasena" => $user->contrasena,
                                "idusuario" => $user->idusuario
                            ];
                            return view('auth.login_empresa',compact('empresas','datoslogin'));
                        }
                         //return view('auth.login_empresa')->with('empresas',$empresas);
                         //->withInput(['nick'=>$request->nick]);
                    } else {
                            $intentosfallidos = User::select('intento_fallido')
                            ->where('idusuario', $user->idusuario)->first();
                            switch($intentosfallidos) {
                                case($intentosfallidos->intento_fallido < 5):

                                    $intentoactual = $intentosfallidos->intento_fallido + 1;
                                    User::where('idusuario', $user->idusuario)
                                        ->update(['intento_fallido' => $intentoactual]);
                                    Log::info("Login fallido del usuario nro: ".$intentoactual." de ".$request->nick);
                                    return redirect('login')->with('mensaje','Usuario y/o password no válidos');
                                    break;
                                case($intentosfallidos->intento_fallido == 5):
                                    $intentoactual = $intentosfallidos->intento_fallido + 1;
                                    User::where('idusuario', $user->idusuario)
                                        ->update(['intento_fallido' => $intentoactual]);
                                    Log::info("Login fallido del usuario nro: ".$intentoactual." de ".$request->nick);
                                    return redirect('login')->with('mensaje','Demasiados intentos fallidos....');
                                    break;
                                 case($intentosfallidos->intento_fallido > 5):
                                    Log::info("Login fallido superior al límite " . $request->nick);
                                    //Flash::error('* Demasiados intentos fallidos *');
                                    $inactivo = User::where('idusuario', $user->idusuario)->update(['activo' => 'NO']);
                                    return redirect('login')->with('mensaje','LA CUENTA SE HA INACTIVADO!');
                                    break;
                            }
                    }

                } else {
                    Log::info("Login de usuario " . $request->nick." con cuenta inactiva");
                    auth()->logout();
                    return redirect('login')->with('mensaje','Cuenta inactiva. Contacte con el Administrador.');
                }
            } else {
                Log::info("Login de usuario " . $request->email . "cuenta no existe");
                return redirect('login')->with('mensaje','Usuario y/o password no válidos');
            }
        }
    }

    
    public function loginempresa(Request $request)
    {
        
        // $acceso_empresas=Acceso_empresa::where('idusuario', $user->idusuario)
        //                 ->pluck('idempresa')->toarray();
        //                 //dd($acceso_empresas);
        //                 $empresa=Empresa::whereIn('idempresa', $acceso_empresas)
        //                 ->orderBy('nombre', 'asc')
        //                 ->first();
        //                 dd($empresa);
        //return view('auth.login_empresa',compact('empresa',$empresa));
        // dd(request()->idusuario);
        // $idempresa = request()->idempresa;
        // Agregar idempresa en la tabla usuarios para el usuario logueado
        User::where('idusuario', request()->idusuario)->update(['idempresa' => request()->idempresa]);

        // dd($idempresa);
        //$idempresa = request()->ruc_ci;
        // return view('home');
        return redirect(route('home'));
        // return view('usuario.create');
    }

    /**
     * Handle logout.
     * @param  void
     * @return Response
     **/
    public function logout()
    {
        auth()->logout();
        return redirect('login');
    }

    public function recovery()
    {
        return view('user.olvide_clave');
    }
}
