<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Cliente;
use App\Models\Ciudad;
use App\Models\Cuenta;
use App\Models\Empresa;
use Illuminate\Http\Request;

class ClienteController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */

     /** Create a new controller instance.
     *  @return void
     **/
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    public function index(Request $request)
    {
        $texto = trim($request->get('texto'));
        $clientes=Cliente::select('c.idcliente',
        'c.denominacion',
        'c.idempresa',
        'e.nombre as empresa_nombre',
        'c.idcuenta',
        'cu.nombre as cuenta',
        'c.ruc',
        'c.direccion',
        'c.telefono',
        'c.estado')
        ->from('cliente as c')
        ->join('empresa as e','c.idempresa','=','e.idempresa')
        ->join('cuenta as cu','c.idcuenta','=','cu.idcuenta')
        ->where(function ($q) {
            //$q->where('idempresa', auth()->user()->idempresa);
             $q->where('c.denominacion','like','%'.trim(request()->texto).'%')
             ->orWhere('c.idcliente','like','%'.trim(request()->texto).'%')
             ->orWhere('cu.nombre','like','%'.trim(request()->texto).'%')
             ->orWhere('c.ruc','like','%'.trim(request()->texto).'%')
             ->orWhere('c.direccion','like','%'.trim(request()->texto).'%')
             ->orWhere('c.telefono','like','%'.trim(request()->texto).'%')
             ->orWhere('c.estado','like','%'.trim(request()->texto).'%');
        })
        ->where('c.idempresa', auth()->user()->idempresa) 
        ->paginate(8)->withQueryString();
        /*------------------------------------------------------- */
        return view('cliente.index',compact('clientes','texto'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $cuentas=Cuenta::where('estado','ACTIVO')
        ->where('idempresa',auth()->user()->idempresa)
        ->get();
        // aqui se tiene q identificar a la variable de la empresa global
        $empresas=Empresa::where('estado','cuentas','ACTIVO')
        ->get();
        return view('cliente.create',compact('empresas','cuentas'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $duplicado = Cliente::Where('ruc', request()->ruc)
                            ->where('idempresa', auth()->user()->idempresa)
                            ->first();
            if (is_null($duplicado)) {
                $campos=[
                    'denominacion'=>'required|string|max:45',
                    'ruc'=>'required|string|max:45',
                ];

                $mensaje = [
                    'required'=> 'El campo :attribute es requerido'
                ];

                $this->validate($request,$campos,$mensaje);
                $datosCliente=request()->except('_token');
                Cliente::insert($datosCliente);
                return redirect('cliente')->with('mensaje','Datos del Cliente, guardados correctamente...');
        }else{                
            return redirect()->back()->with('mensaje','El Nº de RUC ya existe...!'); 
        }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $cliente =Cliente::findOrFail($id);
        $cuentas=Cuenta::where('estado','ACTIVO')
        ->where('idempresa',auth()->user()->idempresa)
        ->get();
        return view('cliente.edit',compact('cliente','cuentas'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        // $duplicado = Cliente::where(function ($q) {
        //     $q->where('denominacion', request()->denominacion)->orWhere('ruc', request()->ruc);
        // })            
        // ->where('idcliente', '!=', $id)            
        $duplicado = Cliente::Where([
            ['ruc', request()->ruc],
            ['idempresa', auth()->user()->idempresa],
            ['idcliente', '!=', $id]
        ])
        ->first();
        if (is_null($duplicado)) {
            $campos=[
                'denominacion'=>'required|string|max:45',
                'ruc'=>'required|string|max:45',
            ];

            $mensaje = [
                'required'=> 'El campo :attribute es requerido'
            ];

            $this->validate($request,$campos,$mensaje);

            $datosCliente=request()->except(['_token','_method']);
            Cliente::where('idcliente','=',$id)->update($datosCliente);
            return redirect('cliente')->with('mensaje','Datos del Cliente, editados correctamente...');
        }else{
            return redirect()->back()->with('mensaje','El Nº de RUC ya existe...!'); 
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        Cliente::destroy($id);
        return redirect('cliente')->with('mensaje','Cliente borrado...');
    }
}
