<?php

namespace App\Http\Controllers;

use App\Models\Cuenta;
use App\Models\Empresa;
use App\Models\Usuario;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CuentaController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

     public function index(Request $request)
    {
        $texto = trim($request->get('texto'));
        // $empresas=Empresa::all();

        // $cuentas = Cuenta::where(function ($q) {
        //     $q->where('codigo', request()->texto)->orWhere('ruc', request()->ruc);
        // })            
        // ->where('idproveedor', '!=', $id)            
        // ->first();


        $cuentas=Cuenta::where(function ($q) {
            //$q->where('idempresa', auth()->user()->idempresa);
             $q->where('codigo','like','%'.trim(request()->texto).'%')->orWhere('nombre','like','%'.trim(request()->texto).'%')->orWhere('estado','like','%'.trim(request()->texto).'%');
        })
        // ->where(function ($a) {
        //     //$q->where('idempresa', auth()->user()->idempresa);
        //     $a->where('codigo','like','%'.trim(request()->texto).'%')->orWhere('nombre','like','%'.trim(request()->texto).'%')->orWhere('estado','like','%'.trim(request()->texto).'%');
        // })
         ->where('idempresa', auth()->user()->idempresa)
        // ->where('codigo', 'like', '%' . $texto . '%') 
        // ->orwhere('nombre', 'like', '%' . $texto . '%') 
        // ->orwhere('estado',$texto) 
        // ->orwhere([
        //     // ['codigo', 'like', '%' . $texto . '%'],
        //     ['nombre', 'like', '%' . $texto . '%'],
        //     ['estado',$texto]
        //  ])
        // ->where('codigo','like','%'.$texto.'%')
        // ->orWhere('nombre','like','%'.$texto.'%')
        // ->orWhere('estado','like','%'.$texto.'%')
        ->paginate(5)->withQueryString();
        /*-------------------------------------------------------------*/
         return view('cuenta.index',compact('cuentas','texto'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $date = DB::select('select date(now()) as fecha');
        // $empresas=Empresa::where('activo',1)
        // ->get();
        return view('cuenta.create',compact('date'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // $duplicado = Empresa::where('nombre', request()->nombre)
        // ->first();
        //     if (is_null($duplicado)) {
        //         $campos=[
        //             'nombre'=>'required|string|max:45',
        //         ];

        //         $mensaje = [
        //             'required'=> 'El campo "Nombre" es requerido'
        //         ];

        //         $this->validate($request,$campos,$mensaje);
                $datosCuenta=request()->except('_token');
                Cuenta::insert($datosCuenta);
                return redirect('cuenta')->with('mensaje','Datos de la Cuenta, guardados correctamente...');
            // }else{                
            //     return redirect()->back()->with('mensaje','La ciudad ya existe...!');
            // }
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $cuenta =Cuenta::findOrFail($id);
        $usuarios=Usuario::all();
        $empresas=Empresa::all();
        return view('cuenta.detalle',compact('cuenta','empresas','usuarios'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $cuenta =Cuenta::findOrFail($id);
        // $empresas=Empresa::where('activo',1)
        // ->get();
        return view('cuenta.edit',compact('cuenta'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $datosCuenta=request()->except(['_token','_method']);
        Cuenta::where('idcuenta','=',$id)->update($datosCuenta);
        return redirect('cuenta')->with('mensaje','Datos de la Cuenta, editados correctamente...');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
