<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use App\Models\Cliente;
use App\Models\Compra;
use App\Models\CtaCobrar;
use App\Models\Detcompra;
use App\Models\Detventa;
use App\Models\Venta;
use Barryvdh\DomPDF\Facade\Pdf as FacadePdf;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class InformesController extends Controller
{
    public function inf_compras()
    {
        $desde = DB::select('select date(now()) as fecha');
        $hasta = DB::select('SELECT DATE_ADD(DATE(NOW()), INTERVAL 30 DAY) as fecha');
        $actual = DB::select('select now() as actual');
        return view('informes/inf_compras', compact('desde', 'hasta', 'actual'));
    }
    public function inf_ventas()
    {
        $desde = DB::select('select date(now()) as fecha');
        $hasta = DB::select('SELECT DATE_ADD(DATE(NOW()), INTERVAL 30 DAY) as fecha');
        $actual = DB::select('select now() as actual');
        return view('informes/inf_ventas', compact('desde', 'hasta', 'actual'));
    }
    public function lista_morosos()
    {
        $desde = DB::select('select date(now()) as fecha');
        $hasta = DB::select('SELECT DATE_ADD(DATE(NOW()), INTERVAL 30 DAY) as fecha');
        $actual = DB::select('select now() as actual');
        return view('informes/lista_morosos', compact('desde', 'hasta', 'actual'));
    }

    public function extracto_cliente(Request $request)
    {
        $texto = trim($request->get('texto'));
        $clientes=Venta::select('v.idcliente',
                                'c.denominacion',
                                'c.ruc_ci',
                                'c.telefono',
                                'c.nota')
        ->from('venta as v')
        ->join('cliente as c','v.idcliente','=','c.idcliente')
        ->where([
            ['condicion', '=', 'CREDITO'],
            ['v.estado', '=', 'PENDIENTE'],
        ])
        ->orWhere('denominacion', 'like', '%' . $texto . '%')
        ->orWhere('ruc_ci', 'like', '%' . $texto . '%')
        ->orWhere('telefono', 'like', '%' . $texto . '%')
        ->orWhere('nota', 'like', '%' . $texto . '%')
        ->groupby('idcliente','c.denominacion','c.ruc_ci','c.telefono','c.nota')
        ->paginate(5);
        /*-------------------------------------------------------------*/
        return view('informes/extracto_cliente', compact('clientes', 'texto'));
    }

    /*-----------------------------------------*/
    public function pdf_compras(Request $request)
    {
        $detalles = Detcompra::select('d.idcompra',
                                    'd.idarticulo',
                                    'a.nombre',
                                    'd.precio',
                                    'd.cantidad',
                                    'd.subtotal')
        ->from('det_compra as d')
        ->join('articulo as a', 'd.idarticulo', '=', 'a.idarticulo')
        ->get();
        /*-------------------------------------------- */            
        if (request()->estado == 'TODAS') {
            $cabecera = Compra::select(
                'c.idcompra',
                'c.fecha',
                'c.condicion',
                'c.iddeposito',
                'de.descripcion',
                'c.idproveedor',
                'p.denominacion',
                'c.fact_nro',
                'c.entrega',
                'c.total',
                'c.estado'
            )
                ->from('compra as c')
                ->join('proveedor as p', 'c.idproveedor', '=', 'p.idproveedor')
                ->join('deposito as de', 'c.iddeposito', '=', 'de.iddeposito')
                ->whereRaw('fecha BETWEEN "' . request()->desdefecha . '" AND "' . request()->hastafecha . '"')
                ->get();
        }
        /*PARA INFORME DE COMPRAS PENDIENTES */
        if (request()->estado == 'PENDIENTE') {
            $cabecera = Compra::select('c.idcompra',
                                        'c.fecha',
                                        'c.condicion',
                                        'c.iddeposito',
                                        'de.descripcion',
                                        'c.idproveedor',
                                        'p.denominacion',
                                        'c.fact_nro',
                                        'c.entrega',
                                        'c.total',
                                        'c.estado')
                                    ->from('compra as c')
                                    ->join('proveedor as p', 'c.idproveedor', '=', 'p.idproveedor')
                                    ->join('deposito as de', 'c.iddeposito', '=', 'de.iddeposito')
                                    ->where('c.estado', 'PENDIENTE')
                                    ->whereRaw('fecha BETWEEN "' . request()->desdefecha . '" AND "' . request()->hastafecha . '"')
                                    ->get();
        }
        if (request()->estado == 'CANCELADA') {
            $cabecera = Compra::select('c.idcompra',
                                        'c.fecha',
                                        'c.condicion',
                                        'c.iddeposito',
                                        'de.descripcion',
                                        'c.idproveedor',
                                        'p.denominacion',
                                        'c.fact_nro',
                                        'c.entrega',
                                        'c.total',
                                        'c.estado')
                                    ->from('compra as c')
                                    ->join('proveedor as p', 'c.idproveedor', '=', 'p.idproveedor')
                                    ->join('deposito as de', 'c.iddeposito', '=', 'de.iddeposito')
                                    ->where('c.estado', 'CANCELADA')
                                    ->whereRaw('fecha BETWEEN "' . request()->desdefecha . '" AND "' . request()->hastafecha . '"')
                                    ->get();
        }
        if (request()->estado == 'ANULADA') {
            $cabecera = Compra::select('c.idcompra',
                                        'c.fecha',
                                        'c.condicion',
                                        'c.iddeposito',
                                        'de.descripcion',
                                        'c.idproveedor',
                                        'p.denominacion',
                                        'c.fact_nro',
                                        'c.entrega',
                                        'c.total',
                                        'c.estado')
                                    ->from('compra as c')
                                    ->join('proveedor as p', 'c.idproveedor', '=', 'p.idproveedor')
                                    ->join('deposito as de', 'c.iddeposito', '=', 'de.iddeposito')
                                    ->where('c.estado', 'ANULADA')
                                    ->whereRaw('fecha BETWEEN "' . request()->desdefecha . '" AND "' . request()->hastafecha . '"')
                                    ->get();
        }

        if (request()->tipo == "RESUMIDO") {
            $pdf = FacadePdf::loadView('informes.pdf_compras_resumido', ['compras' => $cabecera]);
        } else {
            $pdf = FacadePdf::loadView('informes.pdf_compras_detallado', ['compras' => $cabecera, 'detalles' => $detalles]);
        }

        /*-------------------------------------------------------------*/
        $pdf->set_paper('a4', 'landscape');
        return $pdf->stream();
    }

    public function pdf_ventas(Request $request)
    {
        $detalles = Detventa::select('d.idventa',
                                    'd.idarticulo',
                                    'a.nombre',
                                    'd.precio',
                                    'd.cantidad',
                                    'd.subtotal')
        ->from('det_venta as d')
        ->join('articulo as a', 'd.idarticulo', '=', 'a.idarticulo')
        ->get();
        /*----------------------------------------------------*/
        if (request()->estado == 'TODAS') {
            $ventas = Venta::select(
                'v.idventa',
                'v.fecha',
                'v.condicion',
                'v.idcliente',
                'c.denominacion',
                'v.fact_nro',
                'v.entrega',
                'v.total',
                'v.estado',
            )
            ->from('venta as v')
            ->join('cliente as c', 'v.idcliente', '=', 'c.idcliente')
            ->whereRaw('fecha BETWEEN "' . request()->desdefecha . '" AND "' . request()->hastafecha . '"')
            ->get();
        }
        if (request()->estado == 'PENDIENTE') {
            $ventas = Venta::select(
                'v.idventa',
                'v.fecha',
                'v.condicion',
                'v.idcliente',
                'c.denominacion',
                'v.fact_nro',
                'v.entrega',
                'v.total',
                'v.estado',
            )
            ->from('venta as v')
            ->join('cliente as c', 'v.idcliente', '=', 'c.idcliente')
            ->where('v.estado', 'PENDIENTE')
            ->whereRaw('fecha BETWEEN "' . request()->desdefecha . '" AND "' . request()->hastafecha . '"')
            ->get();
        }
        if (request()->estado == 'CANCELADA') {
            $ventas = Venta::select(
                'v.idventa',
                'v.fecha',
                'v.condicion',
                'v.idcliente',
                'c.denominacion',
                'v.fact_nro',
                'v.entrega',
                'v.total',
                'v.estado',
            )
            ->from('venta as v')
            ->join('cliente as c', 'v.idcliente', '=', 'c.idcliente')
            ->where('v.estado', 'CANCELADA')
            ->whereRaw('fecha BETWEEN "' . request()->desdefecha . '" AND "' . request()->hastafecha . '"')
            ->get();
        }
        if (request()->estado == 'ANULADA') {
            $ventas = Venta::select(
                'v.idventa',
                'v.fecha',
                'v.condicion',
                'v.idcliente',
                'c.denominacion',
                'v.fact_nro',
                'v.entrega',
                'v.total',
                'v.estado',
            )
            ->from('venta as v')
            ->join('cliente as c', 'v.idcliente', '=', 'c.idcliente')
            ->where('v.estado', 'ANULADA')
            ->whereRaw('fecha BETWEEN "' . request()->desdefecha . '" AND "' . request()->hastafecha . '"')
            ->get();
        }
        if (request()->tipo == "RESUMIDO") {
            $pdf = FacadePdf::loadView('informes.pdf_ventas_resumido', ['ventas' => $ventas]);
        } else {
            $pdf = FacadePdf::loadView('informes.pdf_ventas_detallado', ['ventas' => $ventas,'detalles'=>$detalles]);
        }
        /*-------------------------------------------------------------*/
        $pdf->set_paper('a4', 'landscape');
        return $pdf->stream();
    }
    public function pdf_morosos(Request $request)
    {
        $morosos = CtaCobrar::select(
            'cta.idventa',
            'v.fecha',
            'v.fact_nro',
            'c.ruc_ci',
            'c.denominacion',
            'cta.cuo_nro',
            'cta.vencimiento',
            'cta.cuo_monto',
            'cta.amortizado',
            'cta.saldo',
            'cta.estado'
        )
            ->from('cta_a_cobrar as cta')
            ->join('venta as v', 'cta.idventa', '=', 'v.idventa')
            ->join('cliente as c', 'v.idcliente', '=', 'c.idcliente')
            ->whereRaw('vencimiento BETWEEN "' . request()->desdefecha . '" AND "' . request()->hastafecha . '"')
            ->get();

        $pdf = FacadePdf::loadView('informes.pdf_morosos', ['cuentas' => $morosos]);
        $pdf->set_paper('a4', 'landscape');
        return $pdf->stream();
    }

    public function pdf_extracto_cliente($id)
    {
        $actual = DB::select('select now() as actual');
        /*---------------------------------- */
        $cuentas=Venta::select('v.idventa',
                                'v.fecha',
                                'v.condicion',
                                'v.idcliente',
                                'c.ruc_ci',
                                'c.denominacion',
                                'v.fact_nro',
                                'v.entrega',
                                'v.total',
                                'v.estado')
        ->from('venta as v')
        ->join('cliente as c', 'v.idcliente', '=', 'c.idcliente')
        ->where([
            ['v.idcliente', '=', $id],
            ['v.estado', '=', 'PENDIENTE'],
            ['v.condicion', '=', 'CREDITO']
        ])
        ->get(); 
        /*----------------------------------------- */
        $detalles = CtaCobrar::all();

        $contar = count($cuentas);
        if ($contar > 0) {
            $pdf = FacadePdf::loadView('informes.pdf_extracto_cliente', ['cuentas' => $cuentas,'detalles' => $detalles,'actual' => $actual]);
            return $pdf->stream();
        } else {
            return redirect('informes/extracto_cliente')->with('mensaje2', 'No posee cuentas pendientes...');
        }
    }
}
