<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Laracasts\Flash\Flash;
use App\Models\Pagina;


class PaginaController extends Controller
{
    /** Create a new controller instance.
     *  @return void
     **/
    public function __construct()
    {
        $this->middleware('auth');
    }
    
    /** Display a listing of the resource.
    * @return \Illuminate\Http\Response
    **/
    public function index(Request $request)
    {
        $texto = trim($request->get('texto'));
        $pagina=Pagina::where('idpagina','like','%'.$texto.'%')
        ->orwhere('nombre','like','%'.$texto.'%')
        ->orwhere('ruta','like','%'.$texto.'%')
        ->orwhere('estado','like','%'.$texto.'%')
        ->paginate(5)->withQueryString();
        return view('pagina.index',compact('pagina','texto'));
    }

    /** Show the form for creating a new resource.
     *  @return \Illuminate\Http\Response
     **/
    public function create()
    {
        return view('pagina.create');
    }

    /** Store a newly created resource in storage.
     *  @param  \Illuminate\Http\Request  $request
     *  @return \Illuminate\Http\Response
     **/
    public function store(Request $request)
    {
        // $campos=[
        //     'nombre'=>'required|string|max:45',
        // ];

        // $mensaje = [
        //     'required'=> 'El campo "Nombre" es requerido'
        // ];

        // $this->validate($request,$campos,$mensaje);
        //dd(request()->nombre,request()->ruta);
        $duplicado = Pagina::where('nombre', request()->nombre)                       
            ->orwhere('ruta', request()->ruta)
            ->first();
        //dd($duplicado);
        if (empty($duplicado)) {

            $data  = [
            'nombre'    => request()->nombre,
            'ruta'      => request()->ruta,
            'menupadre' => request()->menupadre,
            'estado'    => request()->estado
            ];
            $guardado=Pagina::insert($data);
            //dd();
            if (is_null($guardado)) {
                return redirect('pagina')->with('mensaje','No se puedo guardar el registro...');
            }else{
                $datos['pagina'] = Pagina::paginate(5);
                //dd($datos);
                return redirect('pagina')->with('mensaje','Página de sistema guardado...');
            }
        }else{
            return redirect()->back()->with('mensaje','Nombre de Página o ruta ya existe...');  
        }
    }

    
    public function edit($id)
    {
        $pagina =Pagina::findOrFail($id);        
        return view('pagina.edit',compact('pagina'));
    }

    /** Update the specified resource in storage.
     *  @param  \Illuminate\Http\Request  $request
     *  @param  int  $id
     *  @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $duplicado = Pagina::where(function ($q) {
            $q->where('nombre', request()->nombre)->orWhere('ruta', request()->ruta);
        })            
        ->where('idpagina', '!=', $id)            
        ->first();
        //dd($duplicado);
        if (empty($duplicado)) {
            $datospagina  = [
                'nombre'    => request()->nombre,
                'ruta'      => request()->ruta,
                'menupadre' => request()->menupadre,
                'estado'    => request()->estado
            ];
                
            $grabado=Pagina::where('idpagina','=',$id)->update($datospagina);
            
            if(is_null($grabado)){
                return redirect('pagina')->with('mensaje','No se pudo guardar el registro!');
            }else{   
                $datos['pagina'] = Pagina::paginate(5);
                return redirect('pagina')->with('mensaje','Datos de página modificados!');
            }
        }else{
                
            return redirect()->back()->with('mensaje','Nombre de página o ruta ya existe...');  
        }
    }


}
