<?php
namespace App\Http\Controllers;
use App\Http\Controllers\Controller;
use App\Models\Apertura;
use App\Models\Articulo;
use App\Models\Compra;
use App\Models\CtaPagar;
use App\Models\Detcompra;
use App\Models\Pago;
use App\Models\Proveedor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Database\Eloquent\Query;

class PagoController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        /* $dat = Section::where([
            ['servicio_id', '=', $id],
            ['empresa_id', '=', $empresaID]
         ])->orWhere([
            ['servicio_id', '=', $id],
            ['lugar', '=', 'Salons']
         ])->get();
        */
        
       /*  $rolpermisos = rol_permiso::with(['rol', 'formulario'])
        ->where('id_rol', $model->id_rol)
        ->Where(function ($query) {
            $query->orWhere('listar', true)
                ->orWhere('crear', true)
                ->orWhere('editar', true)
                ->orWhere('visualizar', true)
                ->orWhere('imprimir', true)
                ->orWhere('exportar', true)
                ->orWhere('asignar', true)
                ->orWhere('calificar', true)
                ->orWhere('derivar', true)
                ->orWhere('fiscalizar', true)
            ;
        })
        ->get(); */

        /* $texto = '%'.trim($request->get('texto')).'%'; */

        $texto = trim($request->get('texto'));

        /* dd($texto); */


        /* $proveedores=Compra::select() */
/*         $proactivos=Proveedor::where('estado','ACTIVO')
        ->pluck('idproveedor')->toarray();

        $proveedores=Proveedor::select('p.idproveedor',
                                    'p.denominacion',
                                    'p.ruc_ci',
                                    'p.telefono',
                                    'p.nota')
        ->from('proveedor as p')
        ->wherein('p.idproveedor', $proactivos )
        ->where('p.denominacion', 'like', $texto )
        ->where('p.ruc_ci', 'like', $texto )
        ->where('p.telefono', 'like', $texto )
        ->where('p.nota', 'like', $texto )
        ->get();
         */

         /* ->Where(function ($query) {
            $query->where('estado','=','ACTIVO')
            
        }) */

        $proveedores=Proveedor::select('p.idproveedor',
                                    'p.denominacion',
                                    'p.ruc_ci',
                                    'p.telefono',
                                    'p.nota')
        ->from('proveedor as p')
        /* ->where('estado','ACTIVO') */
        ->where('estado','ACTIVO')
        ->orwhere('p.denominacion', 'like', '%'. $texto .'%' )
        ->orwhere('p.ruc_ci', 'like', '%'.$texto .'%' )
        ->orwhere('p.telefono', 'like','%'. $texto .'%' )
        ->orwhere('p.nota', 'like', '%'. $texto .'%' )
        ->paginate(5);
        /*-------------------------------------------------------------*/
        return view('pago.index',compact('proveedores','texto'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        /* dd(request()->idcompra); */
        $texto = trim($request->get('texto'));
        /* OBTENER LA SIGUIENTE CUOTA A PAGAR */
        $sgtecuota = DB::table('cta_a_pagar')
        ->selectRaw('MIN(idcta_a_pagar) AS cuenta')
        ->where([
            ['idcompra', '=', request()->idcompra],
            ['estado', '=', 'PENDIENTE']
        ])
        ->get();
        /*---------------------------------------*/
        /* $conpagos=Pago::select('p.idcta_a_pagar','p.anulado')
        ->from('pago as p')
        ->join('cta_a_pagar as c','p.idcta_a_pagar','=','c.idcta_a_pagar')
        ->join('compra as co','c.idcompra','=','co.idcompra')
        ->where([
            ['p.anulado', '=', 'SI'],
            ['c.idcompra', '=', request()->idcompra]
        ])
        ->first();
        /* dd($conpagos); */

        /*---------------------------------------*/
        $cuotas = CtaPagar::select('idcta_a_pagar',
        'cuo_nro',
        'vencimiento',
        'cuo_monto',
        'amortizado',
        'saldo','estado')
        ->where('idcompra',request()->idcompra)
        ->get();
        
        $compras_credito = Compra::select('c.idcompra','c.fecha','c.fact_nro','c.idproveedor','p.denominacion','c.total')
        ->from('compra as c')
        ->join('proveedor as p','c.idproveedor','=','p.idproveedor')
        ->where([
            ['c.condicion', '=', 'CREDITO'],
            ['c.estado', '=', 'PENDIENTE'],
            ['c.idproveedor', '=', request()->idproveedor]
        ])
        ->get();
        /* dd($compras_credito); */
        $listaok=1;
        $pagos = Pago::select('idcta_a_pagar')->groupby('idcta_a_pagar')->get();
        return view('pago.cta_a_pagar',compact('compras_credito','cuotas','listaok','texto','sgtecuota','pagos'));
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show(Request $request,$id) // se recibe id del proveedor
    {
        $texto = trim($request->get('texto'));
        $compras_credito = Compra::select('c.idcompra',
                                          'c.fecha',
                                          'c.idproveedor',
                                          'c.fact_nro',
                                          'p.denominacion',
                                          'c.total')
        ->from('compra as c')
        ->join('proveedor as p','c.idproveedor','=','p.idproveedor')
        ->where([
            ['c.condicion', '=', 'CREDITO'],
            ['c.estado', '=', 'PENDIENTE'],
            ['c.idproveedor', '=', $id]
        ])
        // ->orwhere('c.fact_nro', 'like', '%' . $texto . '%')
        ->paginate(10);
        $contar = count($compras_credito);
        if($contar>0){
            $listaok=0;
            return view('pago.cta_a_pagar',compact('compras_credito','listaok','texto'));
        }else{
            return redirect('pago')->with('mensaje2','No posee cuentas pendientes...');
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    public function pagar($id)
    {
        $idusuario=auth()->user()->idusuario;
        $operacion = Apertura::select('operacion_nro','idcaja','monto_cierre')
        ->where([
            ['idusuario', '=', $idusuario],
            ['estado', '=', 'ABIERTA']
        ])
        ->get();
        /*----------------------------------------*/
        if(!empty($operacion['0']->operacion_nro)){
            $cuenta=CtaPagar::select('cta.idcta_a_pagar',
                                    'cta.cuo_nro',
                                    'cta.idcompra',
                                    'c.idproveedor',
                                    'cta.vencimiento',
                                    'cta.cuo_monto',
                                    'cta.amortizado',
                                    'cta.saldo')
            ->from('cta_a_pagar as cta')
            ->join('compra as c','cta.idcompra','=','c.idcompra')
            ->where('idcta_a_pagar',$id)
            ->get();
            /*-------------------------------------------- */
            $saldototal = DB::table('cta_a_pagar')
            ->selectRaw('SUM(saldo) AS saldototal')
            ->where([
                ['idcompra', '=', $cuenta['0']->idcompra],
                ['estado', '=', 'PENDIENTE']
            ])
            ->get();        
            return view('pago.pagar',compact('cuenta','operacion','saldototal'));
        }else{
            /* return redirect('pago/'.request()->idproveedor)->with('mensaje','dsfsafdsadf...'); */
            return redirect('pago/1')->with('operacion_necesaria','Deberá iniciar una operación de Caja...');
        }
    }

    public function det_compra($id)
    {
        $compras =Compra::findOrFail($id);
        $proveedores=Proveedor::all();
        $articulos=Articulo::all();
        $detalle = Detcompra::where('idcompra',$id)
        ->get();
        /* ->toarray(); */

        /* dd($detalle); */
        return view('pago.detalle_compras',compact('compras','proveedores','detalle','articulos'));
    }

    public function det_pago($id)
    {
        
        /* $pagos =Pago::findOrFail($id); */
        
        $pagos=Pago::select('p.idpago',
                            'p.fecha',
                            'p.operacion_nro',
                            'p.idcaja',
                            'c.nombre',
                            'p.idcta_a_pagar',
                            'p.cuo_nro',
                            'p.importe',
                            'p.anulado')
        ->from('pago as p')
        ->join('caja as c','p.idcaja','=','c.idcaja')
        ->where('idcta_a_pagar',$id)
        ->get();
        $proveedor = CtaPagar::select('c.idproveedor')
        ->from('cta_a_pagar as cta')
        ->join('compra as c','cta.idcompra','=','c.idcompra')
        ->where('idcta_a_pagar',$id)
        ->get();
        return view('pago.detalle_pagos',compact('pagos','proveedor'));
    }

    public function pagarguardar(Request $request)
    {
        if(str_replace( '.', '', strval(request()->importe)) > request()->saldototal){
            return redirect('pago/pagar/'.request()->idcta_a_pagar)->with('importe_superior','El importe especificado supera el saldo total de la cuenta...');
        }else{
            if(str_replace( '.', '', strval(request()->importe)) > request()->monto_cierre){
                return redirect('pago/pagar/'.request()->idcta_a_pagar)->with('sinsaldo','El importe especificado supera el saldo de la Caja...');
            }else{
                if(str_replace( '.', '', strval(request()->importe)) > str_replace( '.', '', strval(request()->cuo_monto))){
                    $importe = str_replace( '.', '', strval(request()->importe));
                    $cuenta=CtaPagar::where('idcta_a_pagar',request()->idcta_a_pagar)
                    ->get();
                    $idcuenta = $cuenta['0']->idcta_a_pagar;
                    $cuota = $cuenta['0']->cuo_nro;
                    $saldo = $cuenta['0']->saldo;
                    /* dd('adfsadsf'); */
                    while ($importe > $saldo) {
                        $datospago  = [
                            'idcta_a_pagar' => $idcuenta,
                            'cuo_nro' => $cuota,
                            'idcompra'=>request()->idcompra,
                            'operacion_nro' => request()->operacion_nro,
                            'idcaja' => request()->idcaja,
                            'importe'=> $saldo
                        ];
                        $result = Pago::insert($datospago);
                        $importe = $importe - $saldo;
                        $cuenta=CtaPagar::where('idcta_a_pagar',$idcuenta+1)
                        ->get();
                        $idcuenta = $cuenta['0']->idcta_a_pagar;
                        $cuota = $cuenta['0']->cuo_nro;
                        $saldo = $cuenta['0']->saldo;
                    }
                    $datospago  = [
                        'idcta_a_pagar' => $idcuenta,
                        'cuo_nro' => $cuota,
                        'idcompra'=>request()->idcompra,
                        'operacion_nro' => request()->operacion_nro,
                        'idcaja' => request()->idcaja,
                        'importe'=> $importe
                    ];
                    $result = Pago::insert($datospago);
                }else{
                    $datospago  = [
                        'idcta_a_pagar' => request()->idcta_a_pagar,
                        'cuo_nro' => request()->cuo_nro,
                        'idcompra' => request()->idcompra,
                        'operacion_nro' => request()->operacion_nro,
                        'idcaja' => request()->idcaja,
                        'importe'=> str_replace( '.', '', strval(request()->importe))
                    ];
                    $result = Pago::insert($datospago);
                }
                return redirect('pago/'.request()->idproveedor)->with('mensaje','Pago registrado...');
            }
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $cta=Pago::select('*')
        ->from('pago')
        ->where('idpago',$id)
        ->get();
        
        $sgteanular = DB::table('pago')
        ->selectRaw('MAX(idpago) AS idpago')
        ->where([
            ['idcompra', '=', $cta['0']->idcompra],
            ['anulado', '=', 'NO']
        ])
        ->get();        

        $idusuario=auth()->user()->idusuario;
        $operacion = Apertura::select('operacion_nro','idcaja')
        ->where([
            ['idusuario', '=', $idusuario],
            ['estado', '=', 'ABIERTA']
        ])
        ->get();

        if($sgteanular['0']->idpago==intval($id)){
            /* dd('adfasdfasf'); */
            $anulado = [
                'anulado' => 'SI',
                'ope_nro_anulacion'=>$operacion['0']->operacion_nro
            ];
            Pago::where('idpago','=',$id)->update($anulado);
            return redirect('pago/det_pago/'.$cta['0']->idcta_a_pagar)->with('mensaje','Pago Anulado...');
        }else{
            return redirect('pago/det_pago/'.$cta['0']->idcta_a_pagar)->with('mensaje2','existen pagos más recientes...');
        }
    }
}
