<?php

namespace App\Http;

use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;
use Illuminate\Database\Console\DbCommand;
use Illuminate\Database\QueryException;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use PDO;
use App\Models\rol;
use App\Models\Acceso_empresa;
use App\Models\Empresa;
use Exception;
use Carbon\Carbon;


class helpers
{
    /** este helper resuelve la funcionalidad de multiples roles y verifica el permiso que se
     *  consulta desde la view enviando los parámetros usuario, formulario y acción
     *  usuario     = auth()->user()->id_usuario #el usuario logueado actualmente.
     *  pagina      = nombre del pagina que se encuentra guardado en la tabla pagina
     *                y que luego es utilizado en la tabla tbl_rol_permiso
     *  accion      = que corresponden a los campos de la tabla tbl_rol_permiso que contiene el
     *                valor true ó false, determina el permiso en el formulario
     *
     *  @param $usuario,$formulario,$accion
     *  @return boolean
     **/
    // public static function permiso($usuario, $formulario, $accion) todo esto comenta
    // {
    //     # la diferencia está en el nombre de la function hasta que haya un corte para implementar
    //     $idformulario=formulario::where(strtolower('nombre_formulario'),strtolower($formulario))->first();
    //     $roladr=acceso_dependencia_rol::where('id_usuario_asignacion', $usuario )
    //     ->distinct()
    //     ->where('activo_usuario_dependencia', 1)
    //     ->pluck('id_rol')->toarray();
    //     $permiso=rol_permiso::where('id_formulario', $idformulario->id_formulario)
    //     ->whereIn('id_rol', $roladr)
    //     ->where($accion, 1)
    //     ->first();
    //     // dd($permiso);
    //     if(empty($permiso)){
    //         $permiso = 0;
    //     }else{
    //         $permiso = 1;
    //     }
    //     return $permiso;
    // }

    /**
     * @param $usuario,$formulario
     * @return array
     **/
    // public static function permisos($usuario, $formulario)
    // {
    //     $idformulario=formulario::where(strtolower('nombre_formulario'),strtolower($formulario))->first();
    //     $roladr=acceso_dependencia_rol::where('id_usuario_asignacion', $usuario )->first();
    //     $permiso=rol_permiso::where('id_formulario',$idformulario->id_formulario)
    //     ->where('id_rol',$roladr->id_rol)->first();
    //     return $permiso;
    // }

    /**
     * @param $usuario,
     * @return array
     **/
   

    #determinar el acceso a las empresas del usuario
    public static function getEmpresas($usuario){
        $acceso_empresas=acceso_empresa::where('idusuario', $usuario)
        //->where('activo_usuario_dependencia', 1)
        ->pluck('idempresa')->toarray();
        //dd($acceso_empresas);
        
        $empresas=Empresa::whereIn('idempresa', $acceso_empresas)
        ->orderBy('nombre', 'asc')
        ->get();
        //dd($empresas);
        
        return $empresas;
        #return $empresas;
        //  ahi quiero argumentar lo siguiente
        //  la evaluacion todavia no se da en esa interfaz inicial
        //  uno debe de poder listar las empresas disponibles y luego al accionar hacer la evaluacion
        //  digo esto por q se desconoce obvio el usuario y es ese el proceso q va a ocurrir identificar el usuario
        // por eso use la plalabra re-llamado al login
        // volver a llamar al login pero ya con el auth realizado. 
        // ha osea en dos pasos, eso es normal y
        // no hay otra forma puesto q vas a evaluar primero al user y luego deacauerdo a eso listas sus empresas 
        // hay dos formas 
        // hacer en la misma interfaz o redireccionar a otra con la lista de empresa segun acceso_empresa
        // la primera forma es dificil de ahcer?
        // en el procipio, pues es forma de pensar, luego ya nada será dificil
        // y se puede procurar hacer en la misma
        // puedes usar @gues para mostrar la lista de <empresa
        // podemos probar

    } 

        public static function getnameempresa($usuario){

        // $empresa = Empresa::select('nombre')
        // ->where('idempresa',auth()->user()->idempresa)->first();
        $empresa=Empresa::where('idempresa',auth()->user()->idempresa)
        ->pluck('nombre');
        // dd($empresa);
        return $empresa; 

    } 

    /**
     * @param Carbon $date
     * @return string
     **/
    public static function fechahora($date)
    {
       $newfec=$date->format('m-d-Y H:i:s');
        return $newfec;
    }

    ////////////////////////ingramirez////////////////////////////
    public static function separar_con_guiones($objeto,$nombre_del_campo){
        //esta funcion transforma una consulta de eloquent a un array concatenado separado por guiones, sin resultados repetidos
        $array1=[];
        for ($i=0; $i < sizeof($objeto); $i++) {array_push($array1, $objeto[$i]->$nombre_del_campo); }//covertir en array
        $array2 = array_unique($array1); // eliminar duplicados
        $variable='';
        for ($i=0; $i < sizeof($array2); $i++) {$variable .= $array2[$i].' - ';}
        return rtrim($variable, " - "); //elimina el ultimo guión
    }

    public static function limpiar_caracteres_con_for($x){
        for ($i=0; $i < sizeof($x); $i++) {
            $x[$i] = str_replace('%20', " ", $x[$i]);
            $x[$i] = str_replace('%2F', "-", $x[$i]);
            $x[$i] = str_replace('%C3%A9', "é", $x[$i]);
            $x[$i] = str_replace('%C3%B3', "ó", $x[$i]);
            $x[$i] = str_replace('%C3%A1', "á", $x[$i]);
            $x[$i] = str_replace('%C3%AD', "í", $x[$i]);
            $x[$i] = str_replace('%C3%BA', "ú", $x[$i]);
            $x[$i] = str_replace('%C3%BA', "ú", $x[$i]);
            $x[$i] = str_replace('%3A', ":", $x[$i]);
            $x[$i] = str_replace('%2C', ",", $x[$i]);
        }
        return $x;
    }

    public static function limpiar_caracteres($x){
        $x = str_replace('%20', " ", $x);
        $x = str_replace('%2F', "-", $x);
        $x = str_replace('%C3%A9', "é", $x);
        $x = str_replace('%C3%B3', "ó", $x);
        $x = str_replace('%C3%A1', "á", $x);
        $x = str_replace('%C3%AD', "í", $x);
        $x = str_replace('%C3%BA', "ú", $x);
        $x = str_replace('%3A', ":", $x);
        $x = str_replace('%2C', ",", $x);
        return $x;
    }

    
    public static function descargar_pdf_okm($uuid) {
        $url = env('OKM_DIR') . '/openkm/rest/documents/' . $uuid . '/pdf';

        $client = new Client();
        $respu = $client->get($url, [
            'auth' => [env('OKM_USER'), env('OKM_PASSWORD')],
        ]);

        return response($respu->getBody())
            ->header('Content-Type', 'application/pdf')
            ->header('Content-Disposition', 'inline; filename="entrada_adjunto.pdf"');
    }

        

    public static function diaHabil() {
        if (date('D') == 'Sat' || date('D') == 'Sun') {
            return 0;
        } else {
            return 1;
        }
    }

    public static function fecha_texto($fecha) {
        $meses = array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");
        $fecha = new Carbon($fecha);
        $mes = $meses[($fecha->format('n')) - 1];
        return $fecha->format('d') . ' de ' . $mes . ' de ' . $fecha->format('Y');
    }

    public static function fecha_hora_formato($fecha_hora) {
        $fecha_hora = new Carbon($fecha_hora);
        return $fecha_hora->format('d/m/Y H:i:s');
    }

}

