<?php

namespace App\Models;

use Eloquent as Model;

class cargo extends Model
{
    protected $connection = 'sqlsrv';
    public $table = 'tbl_cargo';

    const CREATED_AT = 'fecha_alta';
    const UPDATED_AT = 'fecha_modifico';

    protected $primaryKey = 'id_cargo';

    public $fillable = [
        'fecha_alta',
        'id_tipo_cargo',
        'nombre_cargo',
        'descripcion_cargo',
        'activo_cargo',
        'codigo_cargo',
        'id_usuario_alta',
        'id_usuario_modifico'
    ];

    protected $casts = [
        'id_cargo' => 'integer',
        'id_tipo_cargo' => 'integer',
        'nombre_cargo' => 'string',
        'descripcion_cargo' => 'string',
        'activo_cargo' => 'boolean',
        'codigo_cargo' => 'string',
        'id_usuario_alta' =>'integer',
        'id_usuario_modifico' =>'integer'
    ];

    public static $rules = [
        'id_tipo_cargo' => 'required',
        'nombre_cargo' => 'required|string|max:50',
        'descripcion_cargo' => 'nullable|string|max:100',
        'activo_cargo' => 'boolean',
        'codigo_cargo' => 'required|string|max:50',
        'id_usuario_alta' =>'integer',
        'id_usuario_modifico' =>'integer'
    ];

    /** 
     * @return \Illuminate\Database\Eloquent\Relations\BelongsTo
     **/
    public function tipo_cargo()
    { return $this->belongsTo(\App\Models\tipo_cargo::class, 'id_tipo_cargo');}
    
}
