-- MariaDB dump 10.19  Distrib 10.4.28-MariaDB, for Linux (x86_64)
--
-- Host: localhost    Database: contapy
-- ------------------------------------------------------
-- Server version	10.4.28-MariaDB

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `acceso_empresa`
--

DROP TABLE IF EXISTS `acceso_empresa`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `acceso_empresa` (
  `idempresa` int(11) NOT NULL,
  `idusuario` int(11) NOT NULL,
  `fecha_creacion` timestamp NOT NULL DEFAULT current_timestamp()
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `acceso_empresa`
--

LOCK TABLES `acceso_empresa` WRITE;
/*!40000 ALTER TABLE `acceso_empresa` DISABLE KEYS */;
INSERT INTO `acceso_empresa` VALUES (2,2,'2023-10-30 00:22:49'),(1,2,'2024-02-17 20:38:06');
/*!40000 ALTER TABLE `acceso_empresa` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `asiento`
--

DROP TABLE IF EXISTS `asiento`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `asiento` (
  `idasiento` int(11) NOT NULL AUTO_INCREMENT,
  `idempresa` int(11) NOT NULL,
  `idsucursal` int(11) NOT NULL,
  `nro_asiento` int(11) NOT NULL,
  `fecha` datetime NOT NULL,
  `comentario` text NOT NULL,
  `automatico` varchar(15) DEFAULT 'NULL',
  PRIMARY KEY (`idasiento`),
  KEY `asiento_FK` (`idempresa`),
  KEY `asiento_FK_1` (`idsucursal`),
  CONSTRAINT `asiento_FK` FOREIGN KEY (`idempresa`) REFERENCES `empresa` (`idempresa`),
  CONSTRAINT `asiento_FK_1` FOREIGN KEY (`idsucursal`) REFERENCES `sucursal` (`idsucursal`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `asiento`
--

LOCK TABLES `asiento` WRITE;
/*!40000 ALTER TABLE `asiento` DISABLE KEYS */;
/*!40000 ALTER TABLE `asiento` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `asiento_detalle`
--

DROP TABLE IF EXISTS `asiento_detalle`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `asiento_detalle` (
  `idasiento` int(11) NOT NULL,
  `idcuenta` int(11) NOT NULL,
  `debe` int(11) NOT NULL,
  `haber` int(11) NOT NULL,
  PRIMARY KEY (`idasiento`,`idcuenta`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `asiento_detalle`
--

LOCK TABLES `asiento_detalle` WRITE;
/*!40000 ALTER TABLE `asiento_detalle` DISABLE KEYS */;
INSERT INTO `asiento_detalle` VALUES (1,10,300,0),(1,11,0,300);
/*!40000 ALTER TABLE `asiento_detalle` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_general`
--

DROP TABLE IF EXISTS `balance_general`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_general` (
  `idbalance_general` int(11) NOT NULL AUTO_INCREMENT,
  `idbalance_sumas_saldos` int(11) NOT NULL,
  `idlibro_mayor` int(11) NOT NULL,
  `idlibro_diario` int(11) NOT NULL,
  `idasiento_contable` int(11) NOT NULL,
  `idplan_de_cuenta` int(11) NOT NULL,
  PRIMARY KEY (`idbalance_general`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_general`
--

LOCK TABLES `balance_general` WRITE;
/*!40000 ALTER TABLE `balance_general` DISABLE KEYS */;
/*!40000 ALTER TABLE `balance_general` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `balance_sumas_saldos`
--

DROP TABLE IF EXISTS `balance_sumas_saldos`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `balance_sumas_saldos` (
  `idbalance_sumas_saldos` int(11) NOT NULL AUTO_INCREMENT,
  `idlibro_mayor` int(11) NOT NULL,
  `idlibro_diario` int(11) NOT NULL,
  `idasiento_contable` int(11) NOT NULL,
  `idplan_de_cuenta` int(11) NOT NULL,
  PRIMARY KEY (`idbalance_sumas_saldos`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `balance_sumas_saldos`
--

LOCK TABLES `balance_sumas_saldos` WRITE;
/*!40000 ALTER TABLE `balance_sumas_saldos` DISABLE KEYS */;
/*!40000 ALTER TABLE `balance_sumas_saldos` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ciudad`
--

DROP TABLE IF EXISTS `ciudad`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `ciudad` (
  `idciudad` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `estado` set('ACTIVO','INACTIVO') DEFAULT 'ACTIVO',
  PRIMARY KEY (`idciudad`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ciudad`
--

LOCK TABLES `ciudad` WRITE;
/*!40000 ALTER TABLE `ciudad` DISABLE KEYS */;
INSERT INTO `ciudad` VALUES (1,'Asunción','ACTIVO'),(2,'Lambaré','ACTIVO'),(3,'Capiatá','ACTIVO'),(4,'Luque','ACTIVO'),(5,'San Antonio','ACTIVO'),(6,'Ñemby','ACTIVO'),(7,'Ypané','ACTIVO'),(8,'San Lorenzo','ACTIVO'),(9,'Mariano R. Alonzo','ACTIVO'),(10,'Ciudad del Este','ACTIVO'),(11,'Coronel Oviedo','ACTIVO'),(12,'Fernando de la Mora','ACTIVO'),(13,'Villa elisa','ACTIVO'),(14,'Guarambaré','ACTIVO'),(15,'Limpio','ACTIVO'),(16,'Villeta','ACTIVO'),(17,'Mauricio J. Troche','ACTIVO'),(18,'Paraguarí','ACTIVO'),(19,'Desconocida','ACTIVO'),(20,'Nueva Italia','ACTIVO'),(21,'Itá','ACTIVO'),(22,'Encarnación','ACTIVO');
/*!40000 ALTER TABLE `ciudad` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cliente`
--

DROP TABLE IF EXISTS `cliente`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cliente` (
  `idcliente` int(11) NOT NULL AUTO_INCREMENT,
  `idempresa` int(11) NOT NULL,
  `idcuenta` int(11) DEFAULT NULL,
  `denominacion` varchar(200) NOT NULL,
  `ruc` varchar(30) DEFAULT NULL,
  `direccion` varchar(200) DEFAULT NULL,
  `telefono` varchar(20) DEFAULT NULL,
  `estado` set('ACTIVO','INACTIVO') NOT NULL DEFAULT 'ACTIVO',
  PRIMARY KEY (`idcliente`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cliente`
--

LOCK TABLES `cliente` WRITE;
/*!40000 ALTER TABLE `cliente` DISABLE KEYS */;
INSERT INTO `cliente` VALUES (1,1,NULL,'Felipe Sosa','1256963-1',NULL,NULL,'INACTIVO'),(3,2,NULL,'Salustro','58658',NULL,NULL,'ACTIVO'),(4,1,NULL,'Robert Plant','7170017-7','Julia Miranda Cuento 589','021369258','ACTIVO'),(5,1,NULL,'Fatty Adhesivos S. A.','4777170-4',NULL,NULL,'INACTIVO'),(6,1,NULL,'Diego Inamas','3692654-2',NULL,NULL,'INACTIVO'),(7,1,NULL,'José Delvalle','123456-77',NULL,NULL,'ACTIVO'),(8,1,NULL,'Claudia Delgado','2369547-2',NULL,NULL,'ACTIVO'),(9,1,NULL,'Patricia Kolta','4369258-1',NULL,NULL,'ACTIVO'),(10,1,NULL,'Vicente Jasma','2366417-3',NULL,NULL,'ACTIVO'),(11,1,NULL,'Osvaldo Pier','2258369-1',NULL,NULL,'ACTIVO'),(12,1,NULL,'telefadfaff','3909052',NULL,NULL,'ACTIVO'),(13,1,NULL,'nombre','255','direccion','telerfon','ACTIVO'),(14,1,NULL,'Gustavo Sanchez','25899','direccion','1444','ACTIVO');
/*!40000 ALTER TABLE `cliente` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cuenta`
--

DROP TABLE IF EXISTS `cuenta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cuenta` (
  `idcuenta` int(11) NOT NULL AUTO_INCREMENT,
  `idempresa` int(11) NOT NULL,
  `codigo` varchar(50) NOT NULL,
  `nombre` varchar(30) NOT NULL,
  `tipo_saldo` set('NO IMPUTABLE','DEUDOR','ACREEDOR') NOT NULL COMMENT '0 no imputable - 1 deudor - 2 acreedor',
  `imputable` set('SI','NO') NOT NULL DEFAULT 'NO',
  `tipo_actividad` set('OPERATIVA','INVERSIONES','FINANCIAMIENTO') NOT NULL COMMENT '1. Operativa 2.Inversiones 3.Financiemiento',
  `clasificacion` set('ACTIVO','PASIVO','PATRIMONIO NETO','INGRESO','EGRESO','ORDEN') NOT NULL COMMENT 'Un clasificador de Niveles como',
  `presupuestable` set('SI','NO') DEFAULT NULL COMMENT 'Un indicador de si la cuenta es presupuestable o no (1,0)',
  `nivel` int(11) NOT NULL,
  `fecha_creacion` datetime NOT NULL DEFAULT current_timestamp(),
  `usuario_creacion` int(11) NOT NULL,
  `estado` set('ACTIVO','INACTIVO') NOT NULL DEFAULT 'ACTIVO',
  UNIQUE KEY `cuenta_pk` (`idcuenta`,`idempresa`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cuenta`
--

LOCK TABLES `cuenta` WRITE;
/*!40000 ALTER TABLE `cuenta` DISABLE KEYS */;
INSERT INTO `cuenta` VALUES (1,1,'256331-1','Cuenta 1331','ACREEDOR','NO','INVERSIONES','EGRESO','SI',6,'2023-10-26 00:00:00',1,'ACTIVO'),(2,1,'1245','Cuenta 2','NO IMPUTABLE','NO','OPERATIVA','ACTIVO','SI',1,'2023-10-26 00:00:00',1,'ACTIVO'),(3,2,'1145D','Cuenta luisito 1','NO IMPUTABLE','NO','OPERATIVA','ACTIVO','SI',1,'2023-10-26 00:00:00',1,'ACTIVO'),(4,1,'121545','Cuenta 24545','NO IMPUTABLE','NO','OPERATIVA','ACTIVO','SI',1,'2023-11-06 00:00:00',1,'INACTIVO'),(5,2,'2599','cuenta de prueba','NO IMPUTABLE','NO','OPERATIVA','ACTIVO','SI',1,'2024-02-21 00:00:00',2,'ACTIVO');
/*!40000 ALTER TABLE `cuenta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `empresa`
--

DROP TABLE IF EXISTS `empresa`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `empresa` (
  `idempresa` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(200) NOT NULL,
  `ruc` varchar(25) NOT NULL,
  `direccion` varchar(200) NOT NULL,
  `telefono` varchar(50) NOT NULL,
  `representante_legal` varchar(200) NOT NULL,
  `representante_ruc` varchar(25) NOT NULL,
  `contador` varchar(200) NOT NULL,
  `contador_ruc` varchar(25) NOT NULL,
  `periodo_actual` int(11) DEFAULT NULL,
  `periodo_inicial` date NOT NULL,
  `periodo_final` date NOT NULL,
  `estado` set('ACTIVO','INACTIVO') DEFAULT 'ACTIVO',
  PRIMARY KEY (`idempresa`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `empresa`
--

LOCK TABLES `empresa` WRITE;
/*!40000 ALTER TABLE `empresa` DISABLE KEYS */;
INSERT INTO `empresa` VALUES (1,'A M Reguera  S. R. L.','4777170-4','Bertoni','0983535388','Augusto Saldivar','1258300-4','Vicente Sanchez','15662231',2020,'2020-11-05','2020-11-08','INACTIVO'),(2,'Luisito S. A.','78800666-4','Avda. Felix Bogado c/ Japón','021369852','Victor Jesús Peña','1245789-4','Fatima Ocampos','2563214',NULL,'2023-10-06','2023-10-06','ACTIVO'),(3,'Martinez Hermanos','080011600-2','Avda. E. Ayala','021-369582','Luis Ramirez','2369855-4','Fatima Duarte','4582366-3',NULL,'2024-02-28','2024-02-28','ACTIVO'),(4,'Automoviles Suply','124545','dire','tell','El representete','121','El contador','1212',NULL,'2024-02-13','2024-02-28','ACTIVO'),(5,'Salemma','08009633-1','Avda. E. Ayala','021852636','Lucio Paiva','1245456-4','Diana Almada','256336-5',NULL,'2024-01-29','2024-02-22','ACTIVO');
/*!40000 ALTER TABLE `empresa` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `estado_de_resultado`
--

DROP TABLE IF EXISTS `estado_de_resultado`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `estado_de_resultado` (
  `idestado_de_resultado` int(11) NOT NULL AUTO_INCREMENT,
  `idbalance_sumas_saldos` int(11) NOT NULL,
  `idlibro_mayor` int(11) NOT NULL,
  `idlibro_diario` int(11) NOT NULL,
  `idasiento_contable` int(11) NOT NULL,
  `idplan_de_cuenta` int(11) NOT NULL,
  `ejercicio` date NOT NULL,
  `denominacion` varchar(50) NOT NULL,
  `tipo` varchar(25) NOT NULL,
  PRIMARY KEY (`idestado_de_resultado`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `estado_de_resultado`
--

LOCK TABLES `estado_de_resultado` WRITE;
/*!40000 ALTER TABLE `estado_de_resultado` DISABLE KEYS */;
/*!40000 ALTER TABLE `estado_de_resultado` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `flujo_de_efectivo`
--

DROP TABLE IF EXISTS `flujo_de_efectivo`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `flujo_de_efectivo` (
  `idflujo_de_efectivo` int(11) NOT NULL AUTO_INCREMENT,
  `idbalance_sumas_saldos` int(11) NOT NULL,
  `idlibro_mayor` int(11) NOT NULL,
  `idlibro_diario` int(11) NOT NULL,
  `idasiento_contable` int(11) NOT NULL,
  `idplan_de_cuenta` int(11) NOT NULL,
  `ejercicio` date NOT NULL,
  `denominacion` varchar(50) NOT NULL,
  `tipo` varchar(25) NOT NULL,
  PRIMARY KEY (`idflujo_de_efectivo`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `flujo_de_efectivo`
--

LOCK TABLES `flujo_de_efectivo` WRITE;
/*!40000 ALTER TABLE `flujo_de_efectivo` DISABLE KEYS */;
/*!40000 ALTER TABLE `flujo_de_efectivo` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pagina`
--

DROP TABLE IF EXISTS `pagina`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `pagina` (
  `idpagina` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `estado` set('ACTIVO','INACTIVO') NOT NULL DEFAULT 'ACTIVO',
  PRIMARY KEY (`idpagina`),
  UNIQUE KEY `nombre` (`nombre`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Registro de las interfaces de usuario con un nombre donde primero se ingresa para luego realizar operaciones.';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pagina`
--

LOCK TABLES `pagina` WRITE;
/*!40000 ALTER TABLE `pagina` DISABLE KEYS */;
INSERT INTO `pagina` VALUES (1,'ciudad','ACTIVO'),(2,'cliente','ACTIVO'),(3,'proveedor','ACTIVO'),(4,'cuenta','ACTIVO'),(5,'empresa','ACTIVO'),(6,'sucursal','ACTIVO'),(7,'usuario','ACTIVO');
/*!40000 ALTER TABLE `pagina` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `patrimonio`
--

DROP TABLE IF EXISTS `patrimonio`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `patrimonio` (
  `idpatrimonio` int(11) NOT NULL AUTO_INCREMENT,
  `idbalance_sumas_saldos` int(11) NOT NULL,
  `idlibro_mayor` int(11) NOT NULL,
  `idlibro_diario` int(11) NOT NULL,
  `idasiento_contable` int(11) NOT NULL,
  `idplan_de_cuenta` int(11) NOT NULL,
  `ejercicio` date NOT NULL,
  `denominacion` varchar(50) NOT NULL,
  `tipo` varchar(50) NOT NULL,
  PRIMARY KEY (`idpatrimonio`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `patrimonio`
--

LOCK TABLES `patrimonio` WRITE;
/*!40000 ALTER TABLE `patrimonio` DISABLE KEYS */;
/*!40000 ALTER TABLE `patrimonio` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `perfiles`
--

DROP TABLE IF EXISTS `perfiles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `perfiles` (
  `idperfil` int(11) NOT NULL AUTO_INCREMENT,
  `idusuario` int(11) NOT NULL,
  `idrol` int(11) NOT NULL,
  `perfilestado` set('ACTIVO','INACTIVO') NOT NULL DEFAULT 'ACTIVO',
  PRIMARY KEY (`idperfil`),
  KEY `fk_usuario_has_rol` (`idrol`),
  KEY `fk_usuario_has_rol_usuario1` (`idusuario`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `perfiles`
--

LOCK TABLES `perfiles` WRITE;
/*!40000 ALTER TABLE `perfiles` DISABLE KEYS */;
INSERT INTO `perfiles` VALUES (1,1,1,'ACTIVO'),(2,2,1,'ACTIVO'),(3,3,1,'ACTIVO'),(4,4,2,'ACTIVO'),(5,5,3,'ACTIVO'),(6,6,4,'ACTIVO'),(7,7,5,'ACTIVO'),(8,5,1,'INACTIVO');
/*!40000 ALTER TABLE `perfiles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `periodo_fiscal`
--

DROP TABLE IF EXISTS `periodo_fiscal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `periodo_fiscal` (
  `id_periodo_fiscal` int(11) NOT NULL,
  `idempresa` int(11) NOT NULL,
  `nombre` varchar(10) NOT NULL,
  `fecha_inicio` date NOT NULL,
  `fecha_fin` date NOT NULL,
  `fecha_cierre` date DEFAULT NULL,
  `denominacion_contador` varchar(150) DEFAULT NULL,
  `ruc_contador` varchar(30) DEFAULT NULL,
  `fecha_creacion` timestamp NOT NULL DEFAULT current_timestamp(),
  `fecha_modificacion` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id_periodo_fiscal`,`idempresa`),
  KEY `empresa_periodo_fiscal_fk` (`idempresa`),
  CONSTRAINT `empresa_periodo_fiscal_fk` FOREIGN KEY (`idempresa`) REFERENCES `empresa` (`idempresa`) ON UPDATE NO ACTION
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `periodo_fiscal`
--

LOCK TABLES `periodo_fiscal` WRITE;
/*!40000 ALTER TABLE `periodo_fiscal` DISABLE KEYS */;
/*!40000 ALTER TABLE `periodo_fiscal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `permiso`
--

DROP TABLE IF EXISTS `permiso`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `permiso` (
  `idpermiso` int(11) NOT NULL AUTO_INCREMENT,
  `descripcion` varchar(20) NOT NULL,
  `estado` set('ACTIVO','INACTIVO') DEFAULT 'ACTIVO',
  PRIMARY KEY (`idpermiso`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `permiso`
--

LOCK TABLES `permiso` WRITE;
/*!40000 ALTER TABLE `permiso` DISABLE KEYS */;
INSERT INTO `permiso` VALUES (1,'Administrador','ACTIVO'),(2,'Supervisor','ACTIVO'),(3,'Operador','ACTIVO'),(4,'Consulta','ACTIVO');
/*!40000 ALTER TABLE `permiso` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `proveedor`
--

DROP TABLE IF EXISTS `proveedor`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `proveedor` (
  `idproveedor` int(11) NOT NULL AUTO_INCREMENT,
  `idempresa` int(11) NOT NULL,
  `idcuenta` int(11) DEFAULT NULL,
  `ruc` varchar(25) DEFAULT NULL,
  `denominacion` varchar(35) DEFAULT NULL,
  `direccion` varchar(35) DEFAULT NULL,
  `telefono` varchar(20) NOT NULL,
  `estado` set('ACTIVO','INACTIVO') NOT NULL DEFAULT 'ACTIVO',
  PRIMARY KEY (`idproveedor`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `proveedor`
--

LOCK TABLES `proveedor` WRITE;
/*!40000 ALTER TABLE `proveedor` DISABLE KEYS */;
INSERT INTO `proveedor` VALUES (2,1,NULL,'080025836-1','Salustro CIA','direccion','3232','ACTIVO'),(4,1,NULL,'4864','Salemma','fvdgf','2165','ACTIVO'),(5,1,NULL,'1221','Proveedor 1','direccion a','021225553','INACTIVO'),(6,1,NULL,'12455','Proveedor','asdfa','asdfasdf','ACTIVO'),(7,1,NULL,'12454','Pedro',NULL,'5454','ACTIVO'),(8,1,NULL,'124551','Felipe',NULL,'0212222','ACTIVO');
/*!40000 ALTER TABLE `proveedor` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `rol`
--

DROP TABLE IF EXISTS `rol`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `rol` (
  `idrol` int(11) NOT NULL AUTO_INCREMENT,
  `nombrerol` varchar(50) NOT NULL,
  `estado` set('ACTIVO','INACTIVO') NOT NULL DEFAULT 'ACTIVO',
  `fecha_creacion` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `fecha_modificacion` timestamp NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`idrol`),
  UNIQUE KEY `nombrerol` (`nombrerol`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci COMMENT='Registro de los roles de usuarios';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `rol`
--

LOCK TABLES `rol` WRITE;
/*!40000 ALTER TABLE `rol` DISABLE KEYS */;
INSERT INTO `rol` VALUES (1,'rol 1','ACTIVO','0000-00-00 00:00:00','0000-00-00 00:00:00'),(2,'rol 2','INACTIVO','0000-00-00 00:00:00','0000-00-00 00:00:00'),(3,'rol 3','ACTIVO','0000-00-00 00:00:00','0000-00-00 00:00:00'),(4,'rol 4','ACTIVO','0000-00-00 00:00:00','0000-00-00 00:00:00');
/*!40000 ALTER TABLE `rol` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sucursal`
--

DROP TABLE IF EXISTS `sucursal`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `sucursal` (
  `idsucursal` int(11) NOT NULL AUTO_INCREMENT,
  `nombre` varchar(100) NOT NULL,
  `idempresa` int(11) NOT NULL,
  `estado` set('ACTIVO','INACTIVO') NOT NULL DEFAULT 'ACTIVO',
  PRIMARY KEY (`idsucursal`),
  KEY `sucursal_FK` (`idempresa`),
  CONSTRAINT `sucursal_FK` FOREIGN KEY (`idempresa`) REFERENCES `empresa` (`idempresa`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sucursal`
--

LOCK TABLES `sucursal` WRITE;
/*!40000 ALTER TABLE `sucursal` DISABLE KEYS */;
INSERT INTO `sucursal` VALUES (1,'Casa Matriz',1,'ACTIVO'),(2,'Avda, E. Ayala',1,'ACTIVO'),(4,'Luque',1,'ACTIVO'),(5,'Mariano R. Alonso',1,'ACTIVO'),(6,'4 Mojones',2,'ACTIVO'),(7,'Limpio',2,'ACTIVO'),(8,'San Lorenzo',2,'ACTIVO'),(9,'Carmelitas',1,'ACTIVO'),(10,'Felix Bogado',2,'ACTIVO'),(11,'Avda. E. Ayala',2,'ACTIVO'),(12,'Arroyos y Esteros',1,'ACTIVO');
/*!40000 ALTER TABLE `sucursal` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `usuario`
--

DROP TABLE IF EXISTS `usuario`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `usuario` (
  `idusuario` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Identificador único del registro de usuario',
  `nick` varchar(50) NOT NULL DEFAULT '' COMMENT 'Nombre identificador unico del usuario',
  `nombre` varchar(50) NOT NULL COMMENT 'Apellido del usuario',
  `contrasena` varchar(200) NOT NULL COMMENT 'Palabra de paso de ingreso al sistema.',
  `intento_fallido` int(11) NOT NULL DEFAULT 0,
  `fecha_creacion` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp() COMMENT 'Fecha de creación del registro',
  `fecha_modificacion` timestamp NOT NULL DEFAULT current_timestamp() COMMENT 'Fecha de modificacion del registro.',
  `idempresa` int(11) DEFAULT NULL,
  `estado` set('ACTIVO','INACTIVO') NOT NULL DEFAULT 'ACTIVO',
  PRIMARY KEY (`idusuario`),
  UNIQUE KEY `nick` (`nick`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci COMMENT='Tabla que permite guardar los registros de usuarios del sistema. ';
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `usuario`
--

LOCK TABLES `usuario` WRITE;
/*!40000 ALTER TABLE `usuario` DISABLE KEYS */;
INSERT INTO `usuario` VALUES (1,'admin','Administrador del Sistema','$2y$10$/mEWOAUoPWbkJtUIJ9gLLe.uAiQn7IQ.E6cnZaXyW2Icju2JbEMAm',0,'2024-02-22 11:51:18','2023-10-03 23:33:34',1,'ACTIVO'),(2,'robertmac','Robert Plant','$2y$10$FNaAOm82XTWX0n2P8GJL6OQ7zl355kRpV2fDX3MO4vuRzsgekJXhW',0,'2024-02-20 02:47:30','2023-10-03 23:35:26',1,'ACTIVO');
/*!40000 ALTER TABLE `usuario` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Dumping routines for database 'contapy'
--
