@extends('layout.main')
@section('contenido')
    {{-- mensaje de restricción --}}
    @if (count($errors) > 0)
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    @if (Session::has('mensaje'))
        <div class="alert alert-danger alert-dismissible fade show mb-2 mt-2" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong>Atención. </strong>{{ Session::get('mensaje') }}
        </div>
    @endif
    <div class="card mb-2">
        <form action="{{url('/articulo/'.$articulo->idarticulo)}}" method="post">
            @csrf    
            {{method_field('PATCH')}}
            <div class="card-header">
                <h4>Editar Artículo</h4>
            </div>
            <div class="card-body">
                <div class="row mb-2 mt-2">
                    <div class="col-md-4">
                        <label><b>Nombre</b></label>
                        <input type="text" class="form-control form-control-sm" name="nombre"
                            value="{{ isset($articulo->nombre) ? $articulo->nombre : '' }}" autocomplete="off">
                    </div>
                    <div class="col-md-4">
                        <label><b>Nota</b></label>
                        <textarea name="nota" class="form-control form-control-sm" rows="2">{!!isset($articulo->nota) ? $articulo->nota : ''!!}</textarea>
                    </div>
                    <div class="col-md-4">
                        <label><b>Cuenta</b></label>
                        <div class="input-group">
                            <select name="idcuenta" id="idcuenta" class="form-select form-select-sm" style="width: 340px">
                                @foreach ($cuentas as $cuenta)
                                    @if ($articulo->idcuenta == $cuenta->idcuenta)
                                        <option value="{{ $cuenta->idcuenta }}" selected>{{ $cuenta->nombre }}
                                    @else
                                        <option value="{{ $cuenta->idcuenta }}">{{ $cuenta->nombre }}
                                    @endif
                                @endforeach
                            </select>
                            <button type="button" class="btn btn-secondary btn-sm" data-bs-toggle="modal"
                                data-bs-target="#ModalNuevaCuenta">
                                +
                            </button>
                        </div>
                        <script>
                            $(document).ready(function() {
                                $('#idcuenta').select2();
                            });
                        </script>
                    </div>
    
                </div>
                <div class="col-md-2 mb-2 mt-2">
                    <label for="estado"><b>Estado</b></label>
                    <select name="estado" class="form-select form-select-sm" autocomplete="off" required>
                        @if ($articulo->estado == 'ACTIVO' )
                            <option value="ACTIVO" selected>ACTIVO</option>
                            <option value="INACTIVO">INACTIVO</option>
                        @else
                            <option value="ACTIVO">ACTIVO</option>
                            <option value="INACTIVO" selected>INACTIVO</option>
                        @endif
                    </select>
                </div>
            </div>
            <div class="card-footer" align="right">
                <a href="{{url('/articulo')}}" class="btn btn-secondary" style="text-decoration: none"><i class="bi bi-x-circle"></i> Cancelar</a>
                <button type="submit" class="btn btn-success"><i class="bi bi-floppy2-fill"></i> Guardar</button>
            </div>
        </form>
    </div>
@endsection
