@extends('layout.main')
@section('contenido')
    {{-- mensaje de restricción --}}
    @if (count($errors) > 0)
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <ul>
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif
    @if (Session::has('mensaje'))
        <div class="alert alert-danger alert-dismissible fade show mb-2 mt-2" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong>{{ Session::get('mensaje') }}</strong>
        </div>
    @endif
    <div class="card mb-2">
        <form action="{{ url('/asiento') }}" method="post">
            @csrf
            <div class="card-header">
                <h6 class="text-dark"><b>Registrar un Asiento</b></h6>
            </div>
            <div class="card-body">
                <div class="row mt-0 mb-2">
                    <div class="col-md-2">
                        <label for="floatingInput" class="text-dark"><b>Fecha</b></label>
                        <input type="date" class="form-control form-control-sm" name="fecha" id="fecha" <input type="date"
                            class="form-control" value="{{ $date['0']->fecha }}" 
                            autocomplete="off">
                    </div>
                    {{-- <div class="col-md-2">
                        <label for="floatingInput" class="text-dark"><b>Nº Asiento</b></label>
                        <input type="text" class="form-control form-control-sm"
                            value="{{ isset($asiento->nro_asiento) ? $asiento->nro_asiento : '' }}" name="nombre"
                            autocomplete="off">
                    </div> --}}
                    {{-- <div class="col-md-4">
                        <label for="" class="text-dark"><b>Empresa</b></label>
                        <div class="input-group">
                            <select class="form-select" id="idempresa" name="idempresa" class="form-control">
                                @foreach ($empresas as $empresa)
                                    <option value="{{ $empresa['idempresa'] }}">
                                        {{ $empresa['nombre'] }}</option>
                                @endforeach
                            </select>
                            <button type="button" class="btn btn-secondary btn-sm" data-bs-toggle="modal"
                                data-bs-target="#ModalNuevoBeneficiario">
                                +
                            </button>
                        </div>
                        <script>
                            $(document).ready(function() {
                                $('#idempresa').select2();
                            });
                        </script>
                    </div> --}}
                    <div class="col-md-6">
                        <label for="" class="text-dark"><b>Sucursal</b></label>
                        <div class="input-group">
                            <select class="form-select" id="idsucursal" name="idsucursal" class="form-control" style="width: 300px">
                                @foreach ($sucursales as $sucursal)
                                    <option value="{{ $sucursal['idsucursal'] }}">
                                        {{ $sucursal['nombre'] }}</option>
                                @endforeach
                            </select>
                            <button type="button" class="btn btn-secondary btn-sm" data-bs-toggle="modal"
                                data-bs-target="#ModalNuevoBeneficiario">
                                +
                            </button>
                            <script>
                                $(document).ready(function() {
                                    $('#idsucursal').select2();
                                });
                            </script>
                        </div>
                    </div>
                </div>
                <div class="card mb-3" id="det_transaccion">
                    <div class="card-header">
                        <h6 class="text-dark"><b>Detalle del Asiento</b></h6>
                    </div>
                    <div class="card-body">
                        <div class="row mb-3">
                            {{-- <div class="col-md-4">
                                <div align="right" class="mb-2 d-block d-sm-none">
                                    <label><strong>Cuenta</strong></label>
                                </div>
                                <div class="mb-2 d-none d-sm-block"><label><strong>Cuenta</strong></label></div>
                                <div class="input-group">
                                    <select name="idcuenta" id="idcuenta" class="form-control" style="width: 450px">
                                        @foreach ($cuentas as $cuenta)
                                            <option value="{{ $cuenta['idcuenta'] }}">{{ $cuenta['nombre'] }}
                                            </option>
                                        @endforeach
                                    </select>
                                    <button type="button" class="btn btn-secondary btn-sm" data-bs-toggle="modal"
                                        data-bs-target="#ModalNuevaCategoria">
                                        +
                                    </button>
                                </div>
                                <script>
                                    $(document).ready(function() {
                                        $('#idcuenta').select2();
                                    });
                                </script>
                            </div> --}}
                            <div class="col-md-6">
                                <label for="" class="text-dark"><b>Cuenta</b></label>
                                <div class="input-group">
                                    <select class="form-select" id="idcuenta" name="idcuenta" class="form-control" style="width: 550px">
                                        @foreach ($cuentas as $cuenta)
                                            <option value="{{ $cuenta['idcuenta'] }}">
                                                {{ $cuenta['nombre'] }}</option>
                                        @endforeach
                                    </select>
                                    <button type="button" class="btn btn-secondary btn-sm" data-bs-toggle="modal"
                                        data-bs-target="#ModalNuevoBeneficiario">
                                        +
                                    </button>
                                </div>
                            </div>
                            <script>
                                $(document).ready(function() {
                                    $('#idcuenta').select2();
                                });
                            </script>
                            <div class="col-md-2">
                                <div class="d-none d-sm-block text-dark"><label><strong>Debe</strong></label></div>
                                <div align="right" class="d-block d-sm-none"><label><strong>Debe</strong></label>
                                </div>
                                <input type="tel" class="form-control form-control-sm" id="debe" autocomplete="off"
                                    onkeyup="format(this)" onchange="format(this)">
                            </div>
                            <div class="col-md-2">
                                <div class="d-none d-sm-block text-dark"><label><strong>Haber</strong></label></div>
                                <div align="right" class="d-block d-sm-none text-dark"><label><strong>Haber</strong></label>
                                </div>
                                <input type="tel" class="form-control form-control-sm" id="haber" autocomplete="off"
                                    onkeyup="format(this)" onchange="format(this)">
                            </div>
                            
                            <div class="col-md-1">
                                <div class="d-none d-sm-block text-dark"><label><strong>Agregar</strong></label></div>
                                <button type="button" class="btn btn-primary btn-sm" id='boton-agregar'
                                    role='button'><strong>+</strong></button>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-striped table-sm" id="detalle">
                                <thead>
                                    <tr class="table-primary">
                                        <th width="10%">Código</th>
                                        <th width="40%">Cuenta</th>
                                        <th width="10%">Debe</th>
                                        <th width="10%">Haber</th>
                                        <th width="5%">&nbsp;</th>
                                    </tr>
                                </thead>
                                <tbody id="tbody"></tbody>
                            </table>
                        </div>
                        <div class="row">
                            <div class="col-2" align="right">
                                <div class="form-floating">
                                    <input type="text" readonly value="0" class="form-control" id="totaldebe"
                                        name="total">
                                    <label for="floatingInput"><strong>Total Debe</strong></label>
                                </div>
                            </div>
                            <div class="col-2">
                                <div class="form-floating">
                                    <input type="text" readonly value="0" class="form-control" id="totalhaber"
                                        name="total">
                                    <label for="floatingInput"><strong>Total Haber</strong></label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="card-footer" align="right">
                <a href="{{ url('/asiento') }}" class="btn btn-secondary">Cancelar</a>
                <input type="submit" value="Guardar" class="btn btn-success">
            </div>
        </form>
    </div>
    <style>
        #sinbordefondo {
            background: transparent;
            border: 0;
        }
        #subtotal {
            background: transparent;
            border: 0;
        }
    </style>
    <script type="text/javascript">
        $(document).ready(function(){
            var contador = 1
            var detalle = new Array();
            $("#boton-agregar").click(function(){
                //var idcuenta = $('#idcuenta').val();
                // alert(idcuenta)
                var idcuenta = document.getElementById("idcuenta");
                //alert(idcuenta)
                var cuentanombre = idcuenta.options[idcuenta.selectedIndex].text;
                var debe = $("#debe").val();
                var valordebe = debe.replace(/\./g, '')
                /*-----------------------*/
                var haber = $("#haber").val();
                var valorhaber = haber.replace(/\./g, '')
                /*-----------------------*/
                var totaldebe = $('#totaldebe').val()
                var valortotaldebe = totaldebe.replace(/\./g, '')
                /*----------------------------*/
                var totalhaber = $('#totalhaber').val()
                var valortotalhaber = totalhaber.replace(/\./g, '')
                /*----------------------------*/
                var valortotaldebe = parseFloat(valordebe) + parseFloat(valortotaldebe)
                $('#totaldebe').val(separadorMiles(valortotaldebe))
                $('#totalhaber').val(separadorMiles(valortotalhaber))
                $("#detalle").find('tbody')
                    .append($('<tr>')
                        .append($('<td>'+'<input type="text" class="form-control" id="sinbordefondo" readonly value="'+idcuenta+'" name="det[' + contador +'][idcuenta]"'+'</td>'))
                        .append($('<td>'+'<input type="text" class="form-control" id="sinbordefondo" readonly value="'+cuentanombre+'" name="det[' + contador +'][cuentanombre]"'+'</td>'))
                        .append($('<td>'+'<input type="text" class="form-control" id="sinbordefondo" readonly value="'+debe+'" name="det[' + contador +'][debe]"'+'</td>'))
                        .append($('<td>'+'<input type="text" class="form-control" id="sinbordefondo" readonly value="'+haber+'" name="det[' + contador +'][haber]"'+'</td>'))
                        // .append($('<td>'+'<input type="text" class="form-control" id="subtotal" readonly value="'+separadorMiles(subtotal)+'" name="det[' + contador +'][subtotal]"'+'</td>'))
                        .append($('<td width="5%"><div class="navbar"><a class="btn btn-danger btn-sm" id="borrar"><strong>-</strong></a></div></td>'))
                    .append($('</tr>'))
                );
                contador++
                //console.table(detalle);
                //console.log(detalle)
                //$('#objet_detalle').val(JSON.stringify(detalle));
            });
            // $(document).on('click', '#borrar', function(event) {
            //     $(this).parents("tr").remove(); // se elimina el registro
            //     total = 0 //inicializacion de variable 
            //      $('#detalle tbody tr').each(function() { // se recorre la tabla hasta el registro
            //         var valor = $(this).find('input[id="subtotal"]').val(); //se busca y se asigna el valor del subtotal
            //         total=parseFloat(total)+parseFloat(valor); // se acumula subtotal
            //      });
            //      $('#total').val(total) //se asigna subtotal a total
            // });
        });
        $(document).on('click', '#borrar', function(event) {
            $(this).parents("tr").remove(); // se elimina el registro
            total = 0 //inicializacion de variable 
                $('#detalle tbody tr').each(function() { // se recorre la tabla hasta el registro
                var valor = $(this).find('input[id="subtotal"]').val(); //se busca y se asigna el valor del subtotal
                total=parseFloat(total)+parseFloat(valor); // se acumula subtotal
                });
                $('#total').val(total) //se asigna subtotal a total
        });
    </script>
@endsection
    
    