<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>{{ env('APP_NAME') }} | Log in</title>

    <!-- Font Awesome -->
    <link rel="stylesheet" href="{{ url('/assets/plugins/fontawesome-free/css/all.min.css') }}">
    <link rel="stylesheet" href="{{ url('/css/bootstrap.min.css') }}">
    <link rel="stylesheet" href="{{ url('/iconos/bootstrap-icons.min.css') }}">
    {{--
    <link rel="stylesheet" href="{{ url('/css/bootstrap.css') }}"> --}}
    <script src="{{ asset('/js/bootstrap.min.js') }}"></script>
    <script src="{{ asset('/js/jquery-3.6.0.min.js') }}"></script>
    {{-- <script src="{{ asset('/js/jquery-2.2.4.min.js') }}"></script> --}}
</head>

<body class="hold-transition login-page">
    <br>
    <div class="container">
        <div class="login-box">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header text-center bg-dark text-white">Seleccione la Empresa a Operar</div>
                        <div class="card-body">
                            @if(Session::has('mensaje'))
                                <div class="alert alert-danger alert-dismissible fade show mb-2 mt-2" role="alert">
                                    <button type="button" class="btn-close" data-bs-dismiss="alert"
                                        aria-label="Close"></button>
                                    <strong>{{Session::get('mensaje')}}</strong>
                                </div>
                            @endif
                            <form action="{{ url('/loginempresa') }}" method="post">
                                {{-- <form method="post" action="{{ route('loginempresa') }}"> --}}
                                @if(Auth::user())
                                    @csrf
                                    <input type="hidden" value="{{$datoslogin['idusuario']}}" name="idusuario">
                                    <div class="row mb-3">
                                        <label for="email" class="col-md-4 col-form-label text-md-end"><b>{{ __('Usuario')}}</b></label>
                                        <div class="col-md-6">
                                            <input type="text" readonly class="form-control" name="nombre"
                                                value="{{$datoslogin['nombre']}}">
                                        </div>
                                    </div>
                                    <div class="row mb-3">
                                        <label for="password" class="col-md-4 col-form-label text-md-end"><b>{{ __('Contraseña') }}</b></label>
                                        <div class="col-md-6">
                                            <input type="password" readonly class="form-control" name="contrasena"
                                                value="{{$datoslogin['contrasena']}}">
                                        </div>
                                    </div>
                                    {{-- EMPRESAS --}}
                                    <div class="row mb-3">
                                        {{-- <label for="" class="text-dark">Empresa</label> --}}
                                        <label for="email" class="col-md-4 col-form-label text-md-end"><b>{{ __('Empresa')}}</b></label>
                                        <div class="col-md-6">
                                            <select class="form-select" id="idempresa" name="idempresa"
                                                class="form-control">
                                                @foreach ($empresas as $empresa)
                                                <option value="{{ $empresa['idempresa'] }}">{{ $empresa['nombre'] }}
                                                </option>
                                                @endforeach
                                            </select>
                                        </div>
                                        <script>
                                            $(document).ready(function() {
                                                $('#idempresa').select2();
                                            });
                                        </script>
                                    </div>
                                    <div class="row mb-0">
                                        <div class="col-md-8 offset-md-4">
                                            {{-- BOTON CANCELAR --}}
                                            <a class="btn btn-secondary" href="{{route('logout')}}"><i class="bi bi-x-circle"></i> <b>Cancelar</b></a>
                                            {{-- BOTON SELECCIONAR --}}
                                            <button type="submit" class="btn btn-primary"><i class="bi bi-check2-circle bi-lg"></i> 
                                                <b>{{ __('Seleccionar') }}</b>
                                            </button>
                                        </div>
                                    </div>
                                @endif
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>

</html>