@extends('layout.main')
@section('contenido')
@if(Session::has('mensaje'))
    <div class="alert alert-success alert-dismissible fade show mb-2 mt-2" role="alert">
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        <strong>Ok. </strong>{{Session::get('mensaje')}}
    </div>
@endif
<div class="card mb-2">
    <div class="card-header">
        <div class="navbar">
            <div class="col-md-8" align="left">
                <h4>Lista de Clientes</h4>
            </div>
            <div class="col-md-4">
                <form class="d-flex" role="search">
                    <input name="texto" autocomplete="off" class="form-control me-2" type="search" placeholder="Dato para buscar" aria-label="Buscar" value="{{$texto}}">
                    <button class="btn btn-secondary me-2" type="submit" title="Buscar"><i class="bi bi-search"></i></button>
                    <a href="{{url('/cliente/create')}}" class="btn btn-primary" title="Nuevo" style="text-decoration: none">
                        <i class="bi bi-plus-lg"></i>
                    </a>
                </form>
            </div>
        </div>
    </div>
    <div class="card-body">
        <table class="table table-sm table-condensed table-striped">
            <thead class="table-primary">
                <tr>
                    {{-- <th><div align="center">ID</div></th>     --}}
                    <th>Denominación</th>
                    <th>Cuenta</th>
                    <th>Ruc</th>
                    <th>Dirección</th>
                    <th>Teléfono</th>
                    <th width="7%"><div align="center">Estado</div></th>
                    <th width="5%"><div align="center">Acciones</div></th>
                </tr>
            </thead>
            <tbody>
                @foreach($clientes as $cliente)
                <tr>
                    {{-- <td width=10% align="center">{{$cliente->idcliente}}</td> --}}
                    <td>{{$cliente->denominacion}}</td>
                    <td>{{$cliente->cuenta}}</td>
                    <td>{{$cliente->ruc}}</td>
                    <td>{{$cliente->direccion}}</td>
                    <td>{{$cliente->telefono}}</td>
                    <td>
                        @if ($cliente->estado =='ACTIVO' )
                            ACTIVO
                        @else
                            INACTIVO
                        @endif
                    </td>
                    <td width="8%" align="center">
                        <a href="{{url('/cliente/'.$cliente->idcliente.'/edit')}}" class="btn btn-warning btn-sm" title="Editar" style="cursor: pointer">
                            <i class="bi bi-pencil-fill"></i>
                        </a>  
                    </td>   
                </tr>
                @endforeach
            </tbody>
        </table> 
        {!! $clientes->links() !!}
    </div>
</div>
@endsection