@extends('layout.main')
@section('contenido')
    <div class="card mb-2 mt-2">
        @if (Session::has('mensaje'))
            <div class="alert alert-danger alert-dismissible fade show mb-2 mt-2" role="alert">
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                <strong>{{ Session::get('mensaje') }}</strong>
            </div>
        @endif
        <div class="card">
            <div class="card-header">
                <h4>Detalles de la Cuenta</h4>
            </div>
            <div class="card-body">
                <table class="table table-condensed table-bordered">
                    <tr>
                        <td class="table-primary col-md-2"><b>Id</b></td>
                        <td>{{ $cuenta->idcuenta }}</td>
                    </tr>
                    <tr>
                        <td class="table-primary"><b>Nombre</b></td>
                        <td>{{ $cuenta->nombre }}</td>
                    </tr>
                    <tr>
                        <td class="table-primary"><b>Empresa</b></td>
                        <td>
                            @foreach ($empresas as $empresa)
                                @if ($cuenta->idempresa == $empresa->idempresa)
                                    {{ $empresa->nombre }}
                                @endif
                            @endforeach
                        </td>
                    </tr>
                    <tr>
                        <td class="table-primary"><b>Código</b></td>
                        <td>{{ $cuenta->codigo }}</td>
                    </tr>
                    <tr>
                        <td class="table-primary"><b>Tipo Saldo</b></td>
                        <td>{{ $cuenta->tipo_saldo }}</td>
                    </tr>
                    <tr>
                        <td class="table-primary"><b>Imputable</b></td>
                        <td>{{ $cuenta->imputable }}</td>
                    </tr>
                    <tr>
                        <td class="table-primary"><b>Tipo Actividad</b></td>
                        <td>{{ $cuenta->tipo_actividad }}</td>
                    </tr>
                    <tr>
                        <td class="table-primary"><b>Clasificación</b></td>
                        <td>{{ $cuenta->clasificacion }}</td>
                    </tr>
                    <tr>
                        <td class="table-primary"><b>Presupuestable</b></td>
                        <td>{{ $cuenta->presupuestable }}</td>
                    </tr>
                    <tr>
                        <td class="table-primary"><b>Nivel</b></td>
                        <td>{{ $cuenta->clasificacion }}</td>
                    </tr>
                    <tr>
                        <td class="table-primary"><b>Fecha Creación</b></td>
                        <td>{{ date('d/m/Y', strtotime($cuenta->fecha_creacion)) }}</td>
                        
                    </tr>
                    <tr>
                        <td class="table-primary"><b>Usuario Creación</b></td>
                        <td>
                            @foreach ($usuarios as $usuario)
                                @if ($cuenta->usuario_creacion == $usuario->idusuario)
                                    {{ $usuario->nombre }}
                                @endif
                            @endforeach
                        </td>
                    </tr>
                    <tr>
                        <td class="table-primary"><b>Estado</b></td>
                        <td>
                            @if ($cuenta->activo == 1)
                                ACTIVO
                            @else
                                INACTIVO
                            @endif
                        </td>
                    </tr>
                </table>
            </div>
            <div class="card-footer" align="right">
                <a href="{{ url('/cuenta') }}" class="btn btn-secondary" style="text-decoration: none"><i class="bi bi-arrow-left-circle-fill"></i> Volver</a>
            </div>
        </div>
    </div>
@endsection
