@extends('layout.main')
@section('contenido')
    <div class="card mb-2 mt-2">
        @if (Session::has('mensaje'))
            <div class="alert alert-danger alert-dismissible fade show mb-2 mt-2" role="alert">
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                <strong>Atención. </strong>{{ Session::get('mensaje') }}
            </div>
        @endif
        <form action="{{ url('/cuenta/' . $cuenta->idcuenta) }}" method="post">
            @csrf
            {{ method_field('PATCH') }}
            <div class="card">
                <div class="card-header">
                    <h4>Editar datos de la Cuenta</h4>
                </div>
                <div class="card-body">
                    <input type="hidden" name="idempresa" value="{{ auth()->user()->idempresa }}">
                    <div class="row">
                        {{-- <div class="mb-2 mt-2 col-md-4">
                            <label for="" class="text-dark">Empresa</label>
                            <div class="input-group">
                                <select name="idempresa" id="idempresa" class="form-control">
                                    @foreach ($empresas as $empresa)
                                        @if ($cuenta->idempresa == $empresa->idempresa)
                                            <option value="{{ $empresa->idempresa }}" selected>{{ $empresa->nombre }}
                                            @else
                                            <option value="{{ $empresa->idempresa }}">{{ $empresa->nombre }}
                                        @endif
                                    @endforeach
                                </select>
                                <button type="button" class="btn btn-secondary btn-sm" data-bs-toggle="modal"
                                    data-bs-target="#ModalNuevoBeneficiario">
                                    +
                                </button>
                            </div>
                            <script>
                                $(document).ready(function() {
                                    $('#idempresa').select2();
                                });
                            </script>
                        </div> --}}
                        <div class="mb-2 mt-2 col-md-3">
                            <label for="floatingInput">Código</label>
                            <input type="text" class="form-control"
                                value="{{ isset($cuenta->codigo) ? $cuenta->codigo : '' }}" name="codigo" id="codigo"
                                autocomplete="off" required>
                        </div>
                    </div>
                    <div class="row">
                        <div class="mb-2 mt-2 col-md-4">
                            <label for="floatingInput">Nombre</label>
                            <input type="text" class="form-control"
                                value="{{ isset($cuenta->nombre) ? $cuenta->nombre : '' }}" name="nombre" id="nombre"
                                autocomplete="off" required>
                        </div>
                        <div class="mb-2 mt-2 col-md-3">
                            <label for="">Tipo Saldo</label>
                            <select name="tipo_saldo" class="form-control">
                                <option value="NO IMPUTABLE" <?php if ($cuenta->tipo_saldo == 'NO IMPUTABLE') {
                                    echo 'selected="selected" ';
                                } ?>>No imputable</option>
                                <option value="DEUDOR" <?php if ($cuenta->tipo_saldo == 'DEUDOR') {
                                    echo 'selected="selected" ';
                                } ?>>Deudor</option>
                                <option value="ACREEDOR" <?php if ($cuenta->tipo_saldo == 'ACREEDOR') {
                                    echo 'selected="selected" ';
                                } ?>>Acreedor</option>
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="mb-2 mt-2 col-md-2">
                            <label for="floatingInput">Imputable</label>
                            <select name="imputable" class="form-control">
                                <option value="SI" <?php if ($cuenta->imputable == 'SI') {
                                    echo 'selected="selected" ';
                                } ?>>Si</option>
                                <option value="NO" <?php if ($cuenta->imputable == 'NO') {
                                    echo 'selected="selected" ';
                                } ?>>No</option>
                            </select>
                        </div>
                        <div class="mb-2 mt-2 col-md-2">
                            <label for="floatingInput">Tipo de Actividad</label>
                            <select name="tipo_actividad" class="form-control">
                                <option value="OPERATIVA" <?php if ($cuenta->tipo_actividad == 'OPERATIVA') {
                                    echo 'selected="selected" ';
                                } ?>>Operativa</option>
                                <option value="INVERSIONES" <?php if ($cuenta->tipo_actividad == 'INVERSIONES') {
                                    echo 'selected="selected" ';
                                } ?>>Inversiones</option>
                                <option value="FINANCIAMIENTO" <?php if ($cuenta->tipo_actividad == 'FINANCIAMIENTO') {
                                    echo 'selected="selected" ';
                                } ?>>Financiamiento</option>
                            </select>
                        </div>
                        <div class="mb-2 mt-2 col-md-2">
                            <label for="floatingInput">Clasificacion</label>
                            <select name="clasificacion" class="form-control">
                                <option value="ACTIVO" <?php if ($cuenta->clasificacion == 'ACTIVO') {
                                    echo 'selected="selected" ';
                                } ?>>Activo</option>
                                <option value="PASIVO" <?php if ($cuenta->clasificacion == 'PASIVO') {
                                    echo 'selected="selected" ';
                                } ?>>Pasivo</option>
                                <option value="PATRIMONIO NETO" <?php if ($cuenta->clasificacion == 'PATRIMONIO NETO') {
                                    echo 'selected="selected" ';
                                } ?>>Patrimonio Neto</option>
                                <option value="INGRESO" <?php if ($cuenta->clasificacion == 'INGRESO') {
                                    echo 'selected="selected" ';
                                } ?>>Ingreso</option>
                                <option value="EGRESO" <?php if ($cuenta->clasificacion == 'EGRESO') {
                                    echo 'selected="selected" ';
                                } ?>>Egreso</option>
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        
                        <div class="mb-2 mt-2 col-md-2">
                            <label for="floatingInput">Presupuestable</label>
                            <select name="presupuestable" id="" class="form-control">
                                <option value="SI" <?php if ($cuenta->presupuestable == 'SI') {
                                    echo 'selected="selected" ';
                                } ?>>Si</option>
                                <option value="NO" <?php if ($cuenta->presupuestable == 'NO') {
                                    echo 'selected="selected" ';
                                } ?>>No</option>
                            </select>
                        </div>
                        <div class="mb-2 mt-2 col-md-1">
                            <label for="floatingInput">Nivel</label>
                            <input type="number" class="form-control" value="{{ $cuenta->nivel }}" name="nivel" id="nivel"
                                autocomplete="off" min="1" max="1000">
                        </div>
                        <div class="mb-2 mt-2 col-md-2">
                            <label for="floatingInput">Estado</label>
                            <select name="estado" class="form-control required" autocomplete="off" required>
                                <option value="ACTIVO" <?php if ($cuenta->estado == 'ACTIVO') {
                                    echo 'selected="selected" ';
                                } ?>>Activo</option>
                                <option value="INACTIVO" <?php if ($cuenta->estado == 'INACTIVO') {
                                    echo 'selected="selected" ';
                                } ?>>Inactivo</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="card-footer" align="right">
                    <a href="{{url('/cuenta')}}" class="btn btn-secondary" style="text-decoration: none"><i class="bi bi-x-circle"></i> Cancelar</a>
                    <button type="submit" class="btn btn-success"><i class="bi bi-floppy2-fill"></i> Guardar</button>
                </div>
            </div>
        </form>
    </div>
@endsection
