@extends('layout.main')
@section('contenido')
    @if(Session::has('mensaje'))
        <div class="alert alert-success alert-dismissible fade show mb-2 mt-2" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong>Ok. </strong>{{Session::get('mensaje')}}
        </div>
    @endif
    <div class="card mb-2 mt-2">
        <div class="card-header">
            <div class="navbar">
                <div class="col-md-4" align="left">
                    <h4>Lista de Cuentas</h4>
                </div>
                <div class="col-md-4">
                    <form class="d-flex" role="search">
                        <input name="texto" autocomplete="off" class="form-control me-2" type="search" placeholder="Dato para buscar" aria-label="Buscar" value="{{$texto}}">
                        <button class="btn btn-secondary me-2" type="submit" title="Buscar"><i class="bi bi-search"></i></button>
                        <a href="{{url('/cuenta/create')}}" class="btn btn-primary" title="Nuevo" style="text-decoration: none"><i class="bi bi-plus-lg"></i></a>
                    </form>
                </div>
            </div>
        </div>
        <div class="card-body">
            <table class="table table-condensed table-striped table-sm">
                <thead class="table-primary">
                    <tr>
                        <th><div align="center">Código</div></th>
                        <th>Nombre</th>
                        {{-- <th>Empresa</th> --}}
                        {{-- <th>Tipo Saldo</th>
                        <th>Imputable</th>
                        <th>Tipo Actividad</th>
                        <th>Clasificación</th>
                        <th>Presupuestable</th>
                        <th>Nivel</th> --}}
                        {{-- <th>Fecha Creación</th>
                        <th>Usuario Creación</th> --}}
                        <th width="10%">Estado</th>
                        <th><div align="center">Acciones</div></th>
                    </tr>                    
                </thead>
                <tbody>
                    @foreach($cuentas as $cuenta)
                        {{-- @if ($cuenta->grupo_cuenta>0)
                            {{$cuenta->nombre}}
                            <tr>
                                <td width=10% align="center">{{$cuenta->nombre}}</td>
                                <td>{{$cuenta->nombre}}</td>
                                <td>{{$cuenta->nombre}}</td>
                                <td>{{$cuenta->nombre}}</td>
                                <td>{{$cuenta->nombre}}</td>
                                <td>{{$cuenta->nombre}}</td>
                                <td>{{$cuenta->nombre}}</td>
                                <td>{{$cuenta->nombre}}</td> --}}
                                {{-- <td>{{$cuenta->nombre}}</td>
                                <td>{{$cuenta->nombre}}</td> --}}
                                {{-- <td>
                                    @if ($cuenta->activo == 1 )
                                        ACTIVO
                                    @else
                                        INACTIVO
                                    @endif
                                </td>
                                <td width=15% align="center"> 
                                    <a href="{{url('/cuenta/'.$cuenta->idcuenta.'/edit')}}" class="btn btn-warning btn-sm">
                                        <i class="fas fa-pen fa-lg" title="Editar" style="cursor: pointer"></i>
                                    </a> 
                                </td>
                            </tr>
                        @else --}}
                        <tr>
                            <td width=10% align="center">{{$cuenta->codigo}}</td>
                            <td>{{$cuenta->nombre}}</td>
                            {{-- <td>
                                @foreach ($empresas as $empresa)
                                    @if ($cuenta->idempresa == $empresa->idempresa)
                                        {{ $empresa->nombre }}
                                    @endif
                                @endforeach
                            </td> --}}
                            {{-- <td>{{$cuenta->tipo_saldo}}</td>
                            <td>{{$cuenta->imputable}}</td>
                            <td>{{$cuenta->tipo_actividad}}</td>
                            <td>{{$cuenta->clasificacion}}</td>
                            <td>{{$cuenta->presupuestable}}</td>
                            <td>{{$cuenta->nivel}}</td> --}}
                            {{-- <td>{{$cuenta->nombre}}</td>
                            <td>{{$cuenta->nombre}}</td> --}}
                            <td>
                                @if ($cuenta->estado == 'ACTIVO' )
                                    ACTIVO
                                @else
                                    INACTIVO
                                @endif
                            </td>
                            <td width=15% align="center"> 
                                <a href="{{ url('/cuenta/' . $cuenta->idcuenta) }}" class="btn btn-primary btn-sm" style="cursor: pointer" title="Ver detalles">
                                    <i class="bi bi-binoculars-fill"></i>
                                </a>
                                <a href="{{url('/cuenta/'.$cuenta->idcuenta.'/edit')}}" class="btn btn-warning btn-sm">
                                    <i class="bi bi-pencil-fill" title="Editar" style="cursor: pointer"></i>
                                </a> 
                            </td>
                        </tr>
                        {{-- @endif --}}
                    @endforeach
                </tbody>
            </table> 
            {!! $cuentas->links() !!}
        </div>
    </div>
@endsection