<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="UTF-8">
    <title>{{env('APP_NAME')}}</title>
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="{{ asset('/assets/plugins/fontawesome-free/css/all.min.css') }}">
    <!-- Ionicons -->

    <!-- Tempusdominus Bbootstrap 4 -->
    {{-- <link rel="stylesheet"
        href="{{ url('/') }}/assets/plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css"> --}}
    <!-- iCheck -->
    <link rel="stylesheet" href="{{ asset('/assets/plugins/icheck-bootstrap/icheck-bootstrap.min.css') }}">
    <link href="{{ asset('/css/bootstrap4-toggle.min.css') }}" rel="stylesheet">

    <!-- JQVMap -->
    <link rel="stylesheet" href="{{ asset('/assets/plugins/jqvmap/jqvmap.min.css') }}">
    <!-- Theme style -->
    <link rel="stylesheet" href="{{ asset('/assets/dist/css/adminlte.min.css') }}">
    <!-- overlayScrollbars -->
    <link rel="stylesheet" href="{{ asset('/assets/plugins/overlayScrollbars/css/OverlayScrollbars.min.css') }}">
    <!-- Daterange picker -->
    <link rel="stylesheet" href="{{ asset('/assets/plugins/daterangepicker/daterangepicker.css') }}">
    <link rel="stylesheet" href="{{ asset('/css/estilo.css') }}">
    <link rel="stylesheet" href="{{ asset('/css/fontello.css') }}">
    <link rel="stylesheet" href="{{ asset('/css/bootstrap.min.css') }}">
    {{--  <link rel="stylesheet" href="{{ asset('/css/bootstrap.css') }}">  --}}
    <link rel="stylesheet" href="{{ asset('/css/select2.min.css') }}">
    <link rel="stylesheet" href="{{ asset('/assets/plugins/sweetalert2/sweetalert2.min.css') }}">
    @yield('css')

</head>

<body class="hold-transition sidebar-mini layout-fixed layout-footer-fixed">
    @if (Auth::guest())
        <div class="container">
            <div class="clearfix"></div>
            <div class="card ">
                <div class="card-header">
                    <img src="{{ url('/images/logoCSJ_DGRP.png') }}" width="400px" alt="esigrlogo"
                        class="card-title">
                </div>

                <div class="card-body">
                    <a href="{{ route('login') }}">
                        <i class="card-title  fa fa-user">Por favor inicie sesión aquí</i>
                    </a>
                </div>
            </div>
        </div>
    @else
        <div id="app">
            <div class="wrapper">
                <nav class="main-header navbar navbar-expand navbar-light navbar-white"> <!-- Navbar -->
                    <ul class="navbar-nav"> <!-- Left navbar links -->
                        <li class="nav-item">
                            <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i
                                    class="fas fa-bars"></i></a>
                        </li>
                        <li>
                            <img src="{{ url('/images/logoCSJ_DGRP.png') }}" width="300px" alt="esigrlogo"
                                class="">
                        </li>
                    </ul>
                    <form class="form-inline ml-auto">  <!-- SEARCH FORM -->
                        <div class="input-group input-group-sm">
                            <input class="form-control form-control-navbar" type="search" placeholder="Buscar"
                                aria-label="Search">
                            <div class="input-group-append">
                                <button class="btn btn-navbar" type="submit">
                                    <i class="fas fa-search"></i>
                                </button>
                            </div>
                        </div>
                    </form>
                    <!-- menu de ayuda -->
                    <ul class="navbar-nav ml-auto">
                        <li class="nav-item dropdown">
                            <a class="nav-link" data-toggle="dropdown" href="#">
                                <i class="fas fa-question-circle"></i>Ayuda</a>
                            <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
                                <a class="dropdown-item" target="_blank" href="/files/manual_dgrp.pdf" >
                                    <span class="float-left  text-sm">Manual</span>
                                </a>
                                {{-- <div class="dropdown-divider"></div> --}}
                                {{-- <a href="#" class="dropdown-item">
                                    <span class="float-left  text-sm">Tasas</span>
                                </a> --}}
                                {{-- <div class="dropdown-divider"></div> --}}
                                {{-- <a href="#" class="dropdown-item">
                                    <span class="float-left  text-sm">Mesa de Entrada</span>
                                </a> --}}
                                {{-- <a href="#" class="dropdown-item">
                                    <span class="float-left  text-sm">Mesa de salida</span>
                                </a> --}}
                                {{-- <div class="dropdown-divider"></div> --}}
                                {{-- <a href="#" class="dropdown-item dropdown-footer">Ver todas</a> --}}
                            </div>
                        </li>
                    </ul>
                    <!-- NOTIFICACIONES-->
                    <ul class="navbar-nav ml-auto d-none">
                        <!-- Notifications Dropdown Menu -->
                        <li class="nav-item dropdown">
                            <a class="nav-link" data-toggle="dropdown" href="#">
                                <i class="far fa-bell"></i>
                                <span class="badge badge-warning navbar-badge">15</span>
                            </a>
                            <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
                                <span class="dropdown-item dropdown-header">15 Notifications</span>
                                <div class="dropdown-divider"></div>
                                <a href="#" class="dropdown-item">
                                    <i class="fas fa-envelope mr-2"></i> 4 new messages
                                    <span class="float-right text-muted text-sm">3 mins</span>
                                </a>
                                <div class="dropdown-divider"></div>
                                <a href="#" class="dropdown-item">
                                    <i class="fas fa-users mr-2"></i> 8 friend requests
                                    <span class="float-right text-muted text-sm">12 hours</span>
                                </a>
                                <div class="dropdown-divider"></div>
                                <a href="#" class="dropdown-item">
                                    <i class="fas fa-file mr-2"></i> 3 new reports
                                    <span class="float-right text-muted text-sm">2 days</span>
                                </a>
                                <div class="dropdown-divider"></div>
                                <a href="#" class="dropdown-item dropdown-footer">See All Notifications</a>
                            </div>
                        </li>
                    </ul>
                    <!-- menu de institución -->
                    <ul class="navbar-nav ml-auto d-none">
                        <li class="nav-item dropdown">
                            <a class="nav-link" data-toggle="dropdown" href="#">
                                <i class="lnr lnr-apartment"></i>Institución
                            </a>
                            <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
                                <a href="#" class="dropdown-item">
                                    <span class="float-left  text-sm">Tema 1</span>
                                </a>
                                <div class="dropdown-divider"></div>
                                <a href="#" class="dropdown-item">
                                    <span class="float-left  text-sm">Tema 2</span>
                                </a>
                                <div class="dropdown-divider"></div>
                                <a href="#" class="dropdown-item">
                                    <span class="float-left text-sm">Tema 3</span>
                                </a>
                                <div class="dropdown-divider"></div>
                                <a href="#" class="dropdown-item dropdown-footer">Ver todas</a>
                            </div>
                        </li>
                    </ul>
                    <ul class="navbar-nav ml-auto">
                        <!-- Authentication Links -->
                        <div class="dropdown">
                            <a class="dropdown-toggle" href="#" type="button" data-toggle="dropdown">
                                <i class="fa fa-user">{{auth()->user()->usuario}}</i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-right">
                                <a class="dropdown-item" href="{{url('/password/reset')}}">
                                    <span class="float-left text-sm">Cambiar password</span>
                                </a>
                                <div class="dropdown-divider"></div>
                                <a class="dropdown-item" href="{{route('logout')}}">
                                    <span class="float-left text-sm">Cerrar Sesión</span>
                                </a>
                            </div>
                        </div>
                    </ul>
                </nav>
                <!-- /.navbar -->
                @if(auth()->user()->ldap)
                    {{-- @if(auth()->user()->admin)
                        @include('layouts.sidebar') <!-- cuando todo funcione debe pasar menú dinámico -->
                        @include('layouts.contentconpermiso')
                        @include('layouts.footer')
                    @else --}}
                    @if(count(\App\Http\helpers::getroles(auth()->user()->id_usuario))<=0)
                        @include('layouts.sidebar_sinpermiso')
                        @include('layouts.contentsinpermiso')
                        @include('layouts.footer')
                    @else
                        @include('layouts.menu_dinamico')
                        @include('layouts.contentconpermiso')
                        @include('layouts.footer')
                    @endif
                    {{-- @endif --}}
                @else
                    @include('layouts.sidebar_externo')
                    @include('layouts.contentconpermiso')
                    @include('layouts.footer')
                @endif
            </div>
        </div><!-- end app-->

        <!-- jQuery -->
        <script src="{{ url('/assets/plugins/jquery/jquery.min.js') }}"></script>
        <!-- jQuery UI 1.11.4 -->
        <script src="{{ url('/assets/plugins/jquery-ui/jquery-ui.min.js') }}"></script>
        <!-- NO AGREGAR LINKEABLE DE BOOTSTRAP 4, DA CONFLICTO-->
        <!-- ChartJS -->
        <script src="{{ url('/assets/plugins/chart.js/Chart.min.js') }}"></script>
        <!-- Sparkline -->
        {{--  <script src="{{ url('/assets/plugins/sparklines/sparkline.js') }}"></script>  --}}
        <!-- JQVMap -->
        {{-- <script src="{{ url('/assets/plugins/jqvmap/jquery.vmap.min.js') }}"></script> --}}
        {{-- <script src="{{ url('/assets/plugins/jqvmap/maps/jquery.vmap.usa.js') }}"></script> --}}
        <!-- jQuery Knob Chart -->
        <script src="{{ url('/assets/plugins/jquery-knob/jquery.knob.min.js') }}"></script>
        <!-- daterangepicker -->
        <script src="{{ url('/assets/plugins/moment/moment.min.js') }}"></script>
        {{-- <script src="{{ url('/assets/plugins/daterangepicker/daterangepicker.js') }}"></script> --}}
        <!-- Tempusdominus Bootstrap 4 -->
        {{-- <script src="{{ url('/') }}/assets/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js"></script>
        <script src="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/js/bootstrap4-toggle.min.js"></script> --}}
        <!-- Summernote -->
        {{-- <script src="{{ url('/assets/plugins/summernote/summernote-bs4.min.js') }}"></script> --}}
        <!-- overlayScrollbars -->
        {{-- <script src="{{ url('/assets/plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js') }}"></script> --}}
        <!-- AdminLTE App -->
        <script src="{{ url('/assets/dist/js/adminlte.js') }}"></script>
        <!-- nuevo bootstrap js agregago por ingramsam -->
        <script src="{{ url('/js/bootstrap.min.js') }}"></script>
        {{-- <script src="{{ url('/js/bootstrap.js') }}"></script> --}}
        <script src="{{ url('/assets/plugins/sweetalert2/sweetalert2.all.min.js') }}"></script>
        <!-- auto filtro en droplist -->
        <script src="{{ url('/js/select2.min.js') }}"></script>
        <!-- PARA INICIALIZAR JS GLOBALES PARA TODAS LAS PAGINAS -->
        <script src="{{ url('/js/app_init.js') }}"></script>
        @stack('scripts')
    @endif
</body>

</html>
