<div class="card-body">
    <div class="row">
        <div class='col-sm-6'>
            <div class="input-group input-group-sm mb-3">
                <span class="input-group-text" id="inputGroup-sizing-sm">Página a permitir:</span>
                <input id="myInput" type="text" class="form-control" aria-label="Sizing example input" aria-describedby="inputGroup-sizing-sm"
                placeholder="Ingresa nombre de página a filtrar..">
            </div>
            @push('scripts')
                <script>
                    $(document).ready(function() {
                        $("#myInput").on("keyup", function() {
                            var value = $(this).val().toLowerCase();
                            $("#myTable tr").filter(function() {
                                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
                            });
                        });
                    });
                </script>
            @endpush

            <table class="table table-sm" id="tpermisos">
                <thead class="table">
                    <tr>
                        <th class="active">
                            <input type="checkbox" class="select-all checkbox" name="select-all"/>
                            {!! Form::label('todos', 'Todos') !!}
                        </th>
                        <th>Página</th>
                    </tr>
                </thead>
                <tbody id="myTable">
                    @foreach ($paginasdisponibles as $key => $disponibles)
                        <tr>
                            <td width="1%">
                                {!! Form::checkbox('idpagina', $disponibles->idpagina, null, ['class'=>"chk-box", 'name' => 'permi[' . $key . '][idpagina]']) !!}
                            </td>
                            <td width="5%">
                                {{$disponibles->nombre}}
                                {!! Form::hidden('estado', $disponibles->estado, ['name' => 'permi[' . $key . '][estado]']) !!}
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            
            @if (count($paginasdisponibles) > 0)
                {!! $paginasdisponibles->links() !!} 
            @endif
            
        </div>
        <div class="col-sm-6">
            <div class="input-group input-group-sm mb-3">
                <span class="input-group-text" id="inputGroup-sizing-sm">Páginas permitidas:</span>
                <input id="myaplicados" type="text" class="form-control" aria-label="Sizing example input" aria-describedby="inputGroup-sizing-sm"
                placeholder="Ingresa nombre de página a filtrar..">
            </div>
            @push('scripts')
                <script>
                    $(document).ready(function() {
                        $("#myaplicados").on("keyup", function() {
                            var value = $(this).val().toLowerCase();
                            $("#permiactuales tr").filter(function() {
                                $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
                            });
                        });
                    });
                </script>
            @endpush
                <table class="table table-sm" id="actuales">
                    <thead class="table">
                        <tr>
                            <th>Página</th>
                            <th>Estado</th>
                        </tr>
                    </thead>
                    <tbody id="permiactuales">
                        @foreach ($permiso as $key=>$value)
                            <tr>
                                <td hidden width="1%">
                                    {!! Form::hidden('idpermiso', $value->idpermiso, ['name' => 'permiactual[' . $key . '][idpermiso]']) !!}
                                    {!! Form::hidden('idpagina', $value->idpagina, ['name' => 'permiactual[' . $key . '][idpagina]']) !!}
                                </td>
                                <td width="5%">
                                    {{$value->nombre}}
                                </td>
                                <td width="5%">
                                    @php
                                        echo'<select class="form-control form-control-sm" id="estado" name="permiactual['. $key . '][estado]">'
                                    @endphp
                                     @if ($value->estado == 'ACTIVO')
                                        <option value="ACTIVO" selected>ACTIVO</option>
                                        <option value="INACTIVO">INACTIVO</option>
                                    @else
                                        <option value="ACTIVO">ACTIVO</option>
                                        <option value="INACTIVO" selected>INACTIVO</option>
                                    @endif
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                @if (count($permiso) > 0)
                    {!! $permiso->links() !!}    
                @endif
        </div>
    </div>    
</div>

<div class="card-footer" align="right">
    {!! Form::hidden('updatepermisos', 1) !!}
    {!! Form::hidden('idrol', $rol->idrol) !!}
    <a href="{{url('/rol')}}" class="btn btn-secondary">Cancelar</a>
    <input type="submit" value="Guardar" class="btn btn-success">
</div>

@push('scripts')
<script>
    $('document').ready(function(){
        
        $(".select-all").click(function (){
            $('.chk-box').attr('checked', this.checked)
        });
    
        $(".chk-box").click(function(){
            if($(".chk-box").length == $(".chk-box:checked").length){
                $(".select-all").attr("checked", "checked");
            }else{
                $(".select-all").removeAttr("checked");
            }
        });
    });
</script>
@endpush
