@extends('layout.main')
@section('contenido')
    {{-- mensaje de restricción --}}
    @if(count($errors)>0)
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        <ul>
            @foreach ($errors->all() as $error)
            <li>{{$error}}</li>             
            @endforeach
        </ul>
    </div>
    @endif
    @if(Session::has('mensaje'))
        <div class="alert alert-danger alert-dismissible fade show mb-2 mt-2" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong>Atención. </strong>{{Session::get('mensaje')}}
        </div>
    @endif    
    <div class="card mb-2 mt-2">
        <form action="{{url('/sucursal/'.$sucursales->idsucursal)}}" method="post">
            @csrf    
            {{method_field('PATCH')}}
            <div class="card-header">
                <h4>Editar Sucursal</h4>
            </div>
            <div class="card-body">   
                <input type="hidden" name="idempresa" value="{{ auth()->user()->idempresa }}">   
                <div class="row mb-2 mt-2">
                    <div class="col-md-3">
                        <label><b>Nombre</b></label>
                        <input type="text" class="form-control form-control-sm" value="{{isset($sucursales->nombre)?$sucursales->nombre:''}}" name="nombre" id="nombre" autocomplete="off">
                    </div>      
                    <div class="col-md-4">
                        <label><b>Dirección</b></label>
                        <input type="text" class="form-control form-control-sm" value="{{isset($sucursales->direccion)?$sucursales->direccion:''}}" name="direccion" id="nombre" autocomplete="off">
                    </div>
                    <div class="col-md-3">
                        <label><b>Ciudad</b></label>
                        <div class="input-group">
                            <select name="idciudad" id="idciudad" class="form-select form-select-sm" style="width: 250px">
                                @foreach ($ciudades as $ciudad)
                                    @if ($sucursales->idciudad == $ciudad->idciudad)
                                        <option value="{{ $ciudad->idciudad }}" selected>{{ $ciudad->nombre }}
                                    @else
                                        <option value="{{ $ciudad->idciudad }}">{{ $ciudad->nombre }}
                                    @endif
                                @endforeach
                            </select>
                            <button type="button" class="btn btn-secondary btn-sm" data-bs-toggle="modal"
                                data-bs-target="#ModalNuevaCuenta">
                                +
                            </button>
                        </div>
                        <script>
                            $(document).ready(function() {
                                $('#idcuenta').select2();
                            });
                        </script>
                    </div>
                    <div class="col-md-2">
                        <label><b>Teléfono</b></label>
                        <input type="text" class="form-control form-control-sm" value="{{isset($sucursales->telefono)?$sucursales->telefono:''}}" name="telefono" autocomplete="off">
                    </div>
                </div>
                <div class="col-md-2">
                    <label><b>Estado</b></label>
                    <select name="estado" class="form-select form-select-sm" autocomplete="off" required>
                        @if ($sucursales->estado == 'ACTIVO')
                            <option value="ACTIVO" selected>ACTIVO</option>
                            <option value="INACTIVO">INACTIVO</option>
                        @else
                            <option value="ACTIVO">ACTIVO</option>
                            <option value="INACTIVO" selected>INACTIVO</option>
                        @endif
                    </select>
                </div>
            </div>
            <div class="card-footer" align="right">
                <a href="{{url('/sucursal')}}" class="btn btn-secondary" style="text-decoration: none"><i class="bi bi-x-circle"></i> Cancelar</a>
                    <button type="submit" class="btn btn-success"><i class="bi bi-floppy2-fill"></i> Guardar</button>
            </div>
        </form>
    </div>
@endsection