@extends('layout.main')
@section('contenido')
    @if(Session::has('mensaje'))
        <div class="alert alert-success alert-dismissible fade show mb-2 mt-2" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong>{{Session::get('mensaje')}}</strong>
        </div>
    @endif
    @if(Session::has('danger'))
        <div class="alert alert-danger alert-dismissible fade show mb-2 mt-2" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong>{{Session::get('danger')}}</strong>
        </div>
    @endif
    <div class="card mb-2">
        <div class="card-header">
            <div class="navbar">
                <div class="col-md-4" align="left">
                    <h4>Lista de usuarios</h4>
                </div>
                <div class="col-md-4">
                    <form class="d-flex" role="search">
                        <input name="texto" autocomplete="off" class="form-control me-2" type="search" placeholder="Dato para Buscar" aria-label="Buscar" value="{{$texto}}">
                        <button class="btn btn-secondary me-2" type="submit" title="Buscar"><i class="bi bi-search"></i></button>
                        <a href="{{url('/usuario/create')}}" class="btn btn-primary" title="Nuevo" style="text-decoration: none"><i class="bi bi-plus-lg"></i></a>
                    </form>
                </div>
            </div>
        </div>
        <div class="card-body">
            <table class="table table-condensed table-striped table-sm">
                <thead class="table-primary">
                    <tr>
                        <th><div align="center">ID</div></th>
                        <th>Nick</th>
                        <th>Nombre</th>
                        <th>Estado</th>
                        <th><div align="center">Acciones</div></th>
                    </tr>                    
                </thead>
                <tbody>
                    @foreach($usuarios as $usuario)
                        <tr>
                            <td width=10% align="center">{{$usuario->idusuario}}</td>
                            <td>{{$usuario->nick}}</td>
                            <td>{{$usuario->nombre}}</td>
                            <td>
                                @if ($usuario->estado == 'ACTIVO' )
                                    ACTIVO
                                @else
                                    INACTIVO
                                @endif
                            </td>
                            <td width=15% align="center"> 
                                <a href="{{url('/usuario/'.$usuario->idusuario.'/edit')}}" class="btn btn-warning btn-sm" title="Editar" style="cursor: pointer">
                                    <i class="bi bi-pencil-fill"></i>
                                </a>  
                                <a href="{{url('/usuario/cambiarpass/'.$usuario->idusuario)}}" class="btn btn-warning btn-sm" title="Cambiar contraseña" style="cursor: pointer">
                                    <i class="bi bi-fingerprint"></i>
                                </a>
                                <a href="{{url('/usuario/perfiles/'.$usuario->idusuario)}}" class="btn btn-warning btn-sm" title="Perfiles" style="cursor: pointer">
                                    <i class="bi bi-person-lines-fill"></i>
                                </a>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table> 
            {!! $usuarios->links() !!}
        </div>
    </div>
@endsection