<?php $__env->startSection('contenido'); ?>
    <div class="card mb-2 mt-2">
        <?php if(Session::has('mensaje')): ?>
            <div class="alert alert-danger alert-dismissible fade show mb-2 mt-2" role="alert">
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                <strong>Atención. </strong><?php echo e(Session::get('mensaje')); ?>

            </div>
        <?php endif; ?>
        <form action="<?php echo e(url('/cuenta')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="card">
                <div class="card-header">
                    <h4>Registrar una nueva Cuenta</h4>
                </div>
                <div class="card-body">
                    
                    <input type="hidden" name="usuario_creacion" value="<?php echo e(auth()->user()->idusuario); ?>">
                    <input type="hidden" name="fecha_creacion" value="<?php echo e($date['0']->fecha); ?>">
                    <input type="hidden" name="idempresa" value="<?php echo e(auth()->user()->idempresa); ?>">
                    
                    <div class="row">
                        
                        <div class="mb-2 mt-2 col-md-3">
                            <label for="floatingInput">Código</label>
                            <input type="text" class="form-control"
                                value="<?php echo e(isset($cuenta->codigo) ? $cuenta->codigo : ''); ?>" name="codigo" id="codigo"
                                autocomplete="off" required>
                        </div>
                    </div>
                    <div class="row">
                        <div class="mb-2 mt-2 col-md-4">
                            <label for="floatingInput">Nombre</label>
                            <input type="text" class="form-control"
                                value="<?php echo e(isset($cuenta->nombre) ? $cuenta->nombre : ''); ?>" name="nombre" id="nombre"
                                autocomplete="off" required>
                        </div>
                        <div class="mb-2 mt-2 col-md-3">
                            <label for="">Tipo Saldo</label>
                            <select name="tipo_saldo" id="" class="form-control">
                                <option value="NO IMPUTABLE">No imputable</option>
                                <option value="DEUDOR">Deudor</option>
                                <option value="ACREEDOR">Acreedor</option>
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="mb-2 mt-2 col-md-2">
                            <label for="floatingInput">Imputable</label>
                            <select name="" id="" class="form-control">
                                <option value="SI">Si</option>
                                <option value="NO">No</option>
                            </select>
                        </div>
                        <div class="mb-2 mt-2 col-md-2">
                            <label for="floatingInput">Tipo de Actividad</label>
                            <select name="tipo_actividad" id="" class="form-control">
                                <option value="OPERATIVA">Operativa</option>
                                <option value="INVERSIONES">Inversiones</option>
                                <option value="FINANCIAMIENTO">Financiamiento</option>
                            </select>
                        </div>
                        <div class="mb-2 mt-2 col-md-2">
                            <label for="floatingInput">Clasificacion</label>
                            <select name="clasificacion" id="" class="form-control">
                                <option value="ACTIVO">Activo</option>
                                <option value="PASIVO">Pasivo</option>
                                <option value="PATRIMONIO NETO">Patrimonio Neto</option>
                                <option value="INGRESO">Ingreso</option>
                                <option value="EGRESO">Egreso</option>
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="mb-2 mt-2 col-md-2">
                            <label for="floatingInput">Presupuestable</label>
                            <select name="presupuestable" id="" class="form-control">
                                <option value="SI">Si</option>
                                <option value="NO">No</option>
                            </select>
                        </div>
                        <div class="mb-2 mt-2 col-md-1">
                            <label for="floatingInput">Nivel</label>
                            <input type="number" class="form-control" value="1" name="nivel" id="nivel"
                                autocomplete="off" min="1" max="1000">
                        </div>
                    </div>
                </div>
                <div class="card-footer" align="right">
                    <a href="<?php echo e(url('/cuenta')); ?>" class="btn btn-secondary" style="text-decoration: none"><i class="bi bi-x-circle"></i> Cancelar</a>
                    <button type="submit" class="btn btn-success"><i class="bi bi-floppy2-fill"></i> Guardar</button>
                </div>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/contapy/resources/views/cuenta/create.blade.php ENDPATH**/ ?>