<?php $__env->startSection('contenido'); ?>
    <?php if(Session::has('mensaje')): ?>
        <div class="alert alert-success alert-dismissible fade show mb-2 mt-2" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong>Ok. </strong><?php echo e(Session::get('mensaje')); ?>

        </div>
    <?php endif; ?>
    <div class="card mb-2 mt-2">
        <div class="card-header">
            <div class="navbar">
                <div class="col-md-4" align="left">
                    <h4>Lista de Empresas</h4>
                </div>
                <div class="col-md-4">
                    <form class="d-flex" role="search">
                        <input name="texto" autocomplete="off" class="form-control me-2" type="search" placeholder="Dato para buscar" aria-label="Buscar" value="<?php echo e($texto); ?>">
                        <button class="btn btn-secondary me-2" type="submit" title="Buscar"><i class="bi bi-search"></i></button>
                        <a href="<?php echo e(url('/empresa/create')); ?>" class="btn btn-primary btn" title="Nuevo" style="text-decoration: none"><i class="bi bi-plus-lg"></i></a>
                    </form>
                </div>
            </div>
        </div>
        <div class="card-body">
            <table class="table table-condensed table-striped table-sm table-bordered">
                <thead class="table-primary">
                    <tr>
                        
                        <th>Nombre</th>
                        <th>Ruc</th>
                        <th>Dirección</th>
                        <th>Ciudad</th>
                        <th>Teléfono</th>
                        <th width="7%"><div align="center">Estado</div></th>
                        <th width="5%"><div align="center">Acciones</div></th>
                    </tr>                    
                </thead>
                <tbody>
                    <?php $__currentLoopData = $empresas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $empresa): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            
                            <td><?php echo e($empresa->nombre); ?></td>
                            <td><?php echo e($empresa->ruc); ?></td>
                            <td><?php echo e($empresa->direccion); ?></td>
                            <td><?php echo e($empresa->ciudad); ?></td>
                            <td><?php echo e($empresa->telefono); ?></td>
                            <td align="center">
                                <?php if($empresa->estado == 'ACTIVO' ): ?>
                                    ACTIVO
                                <?php else: ?>
                                    INACTIVO
                                <?php endif; ?>
                            </td>
                            <td align="center"> 
                                <a href="<?php echo e(url('/empresa/'.$empresa->idempresa.'/edit')); ?>" class="btn btn-warning btn-sm" title="Editar">
                                    <i class="bi bi-pencil-fill" style="cursor: pointer"></i>
                                </a> 
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table> 
            <?php echo $empresas->links(); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/contapy/resources/views/empresa/index.blade.php ENDPATH**/ ?>