<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo e(env('APP_NAME')); ?> | Log in</title>
    <!-- Font Awesome -->
    
    <link rel="stylesheet" href="<?php echo e(url('/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(url('/iconos/bootstrap-icons.min.css')); ?>">
    
</head>

<body class="hold-transition login-page">
    <br>
    <div class="container">
        <div class="login-box">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header text-center bg-dark text-white">
                            <?php echo e(env('APP_NAME')); ?> | Acceso
                        </div>
                        <?php if(Session::has('mensaje')): ?>
                            <div class="alert alert-danger alert-dismissible fade show m-2" role="alert">
                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                <strong>Atención: </strong><?php echo e(Session::get('mensaje')); ?>

                            </div>
                        <?php endif; ?>
                        <div class="card-body">
                            <form method="POST" action="<?php echo e(route('login')); ?>">
                                <?php echo csrf_field(); ?>
                                <div class="row mb-3">
                                    <label for="email"
                                        class="col-md-4 col-form-label text-md-end"><b><?php echo e(__('Usuario')); ?></b></label>

                                    <div class="col-md-6">
                                        <input id="nick" type="text" class="form-control" name="nick" required autocomplete="off" autofocus>
                                    </div>
                                </div>

                                <div class="row mb-3">
                                    <label for="password"
                                        class="col-md-4 col-form-label text-md-end"><b><?php echo e(__('Contraseña')); ?></b></label>

                                    <div class="col-md-6">
                                        <input id="contrasena" type="password"
                                            class="form-control <?php $__errorArgs = ['constrasena'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            name="contrasena" required autocomplete="current-password">

                                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="invalid-feedback" role="alert">
                                                <strong><?php echo e($message); ?></strong>
                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                               
                                <div class="row mb-0">
                                    <div class="col-md-8 offset-md-4">
                                        <button type="submit" class="btn btn-primary">
                                            <i class="bi bi-person-check"></i> <b><?php echo e(__('Ingresar')); ?></b>
                                        </button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
    <script src="<?php echo e(asset('/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('/js/jquery-3.6.0.min.js')); ?>"></script>
</html>
<?php /**PATH /opt/lampp/htdocs/contapy/resources/views/auth/login.blade.php ENDPATH**/ ?>