<?php $__env->startSection('contenido'); ?>
    
    <?php if(count($errors) > 0): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
    <?php endif; ?>
    <?php if(Session::has('mensaje')): ?>
        <div class="alert alert-danger alert-dismissible fade show mb-2 mt-2" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong>Atención. </strong><?php echo e(Session::get('mensaje')); ?>

        </div>
    <?php endif; ?>
    <div class="card mb-2">
        <form action="<?php echo e(url('/cliente')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="card-header">
                <h4>Registrar un nuevo Cliente</h4>
            </div>
            <div class="card-body">
                <input type="hidden" name="idempresa" value="<?php echo e(auth()->user()->idempresa); ?>">   
                
                <div class="row">
                    <div class="col-md-2 mb-2 mt-2">
                        <label for="floatingInput"><b>Ruc</b></label>
                        <input type="text" class="form-control" name="ruc"
                            value="<?php echo e(isset($cliente->ruc) ? $cliente->ruc : ''); ?>" autocomplete="off">
                    </div>
                    <div class="col-md-4 mb-2 mt-2">
                        <label for="floatingInput"><b>Denominación</b></label>
                        <input type="text" class="form-control" name="denominacion"
                            value="<?php echo e(isset($cliente->denominacion) ? $cliente->denominacion : ''); ?>" autocomplete="off">
                    </div>
                    <div class="col-md-4 mb-2 mt-2">
                        <label for="floatingInput"><b>Dirección</b></label>
                        <input type="text" class="form-control" name="direccion"
                            value="<?php echo e(isset($cliente->direccion) ? $cliente->direccion : ''); ?>" autocomplete="off">
                    </div>
                    <div class="col-md-2 mb-2 mt-2">
                        <label for="floatingInput"><b>Teléfono</b></label>
                        <input type="text" class="form-control" name="telefono"
                            value="<?php echo e(isset($cliente->telefono) ? $cliente->telefono : ''); ?>" autocomplete="off">
                    </div>
                </div>
                <div class="col-md-6">
                    <label for="" class="text-dark"><b>Cuenta</b></label>
                    <div class="input-group">
                        <select class="form-select" id="idcuenta" name="idcuenta" class="form-control" style="width: 550px">
                            <?php $__currentLoopData = $cuentas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cuenta): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($cuenta['idcuenta']); ?>">
                                    <?php echo e($cuenta['nombre']); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                        <button type="button" class="btn btn-secondary btn-sm" data-bs-toggle="modal"
                            data-bs-target="#ModalNuevoBeneficiario">
                            +
                        </button>
                    </div>
                    <script>
                        $(document).ready(function() {
                            $('#idcuenta').select2();
                        });
                    </script>
                </div>

            </div>
            <div class="card-footer" align="right">
                <a href="<?php echo e(url('/cliente')); ?>" class="btn btn-secondary" style="text-decoration: none"><i class="bi bi-x-circle"></i> Cancelar</a>
                <button type="submit" class="btn btn-success"><i class="bi bi-floppy2-fill"></i> Guardar</button>
            </div>
        </form>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/contapy/resources/views/cliente/create.blade.php ENDPATH**/ ?>