<?php $__env->startSection('contenido'); ?>
    <?php if(Session::has('mensaje')): ?>
        <div class="alert alert-success alert-dismissible fade show mb-2 mt-2" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong>Ok. </strong><?php echo e(Session::get('mensaje')); ?>

        </div>
    <?php endif; ?>
    <div class="card mb-2 mt-2">
        <div class="card-header">
            <div class="navbar">
                <div class="col-md-8" align="left">
                    <h4>Lista de Sucursales</h4>
                </div>
                <div class="col-md-4">
                    <form class="d-flex" role="search">
                        <input name="texto" autocomplete="off" class="form-control me-2" type="search" placeholder="Dato para buscar" aria-label="Buscar" value="<?php echo e($texto); ?>">
                        <button class="btn btn-secondary me-2" type="submit" title="Buscar"><i class="bi bi-search"></i></button>
                        <a href="<?php echo e(url('/sucursal/create')); ?>" class="btn btn-primary" title="Nuevo" style="text-decoration: none"><i class="bi bi-plus-lg"></i></a>
                    </form>
                </div>
            </div>
        </div>
        <div class="card-body">
            <table class="table table-sm table-condensed table-striped table-bordered">
                <thead class="table-primary">
                    <tr>
                        
                        <th width="30%">Nombre</th>
                        <th width="20%">Dirección</th>
                        <th>Ciudad</th>
                        <th>Teléfono</th>
                        <th width="7%"><div align="center">Estado</div></th>
                        <th width="5%"><div align="center">Acciones</div></th>
                    </tr>                    
                </thead>
                <tbody>
                    <?php $__currentLoopData = $sucursales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sucursal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            
                            <td><?php echo e($sucursal->nombre); ?></td>
                            <td><?php echo e($sucursal->direccion); ?></td>
                            <td><?php echo e($sucursal->ciudad); ?></td>
                            <td><?php echo e($sucursal->telefono); ?></td>
                            <td align="center">
                                <?php if($sucursal->estado == 'ACTIVO' ): ?>
                                    ACTIVO
                                <?php else: ?>
                                    INACTIVO
                                <?php endif; ?>
                            </td>
                            <td align="center"> 
                                <a href="<?php echo e(url('/sucursal/'.$sucursal->idsucursal.'/edit')); ?>" class="btn btn-warning btn-sm">
                                    <i class="bi bi-pencil-fill" title="Editar" style="cursor: pointer"></i>
                                </a> 
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table> 
            <?php echo $sucursales->links(); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/contapy/resources/views/sucursal/index.blade.php ENDPATH**/ ?>