<?php $__env->startSection('contenido'); ?>
    <?php if(Session::has('mensaje')): ?>
        <div class="alert alert-success alert-dismissible fade show mb-2 mt-2" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong><?php echo e(Session::get('mensaje')); ?></strong>
        </div>
    <?php endif; ?>
    <?php if(Session::has('danger')): ?>
        <div class="alert alert-danger alert-dismissible fade show mb-2 mt-2" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong><?php echo e(Session::get('danger')); ?></strong>
        </div>
    <?php endif; ?>
    <div class="card mb-2">
        <div class="card-header">
            <div class="navbar">
                <div class="col-md-4" align="left">
                    <h4>Lista de usuarios</h4>
                </div>
                <div class="col-md-4">
                    <form class="d-flex" role="search">
                        <input name="texto" autocomplete="off" class="form-control me-2" type="search" placeholder="Dato para Buscar" aria-label="Buscar" value="<?php echo e($texto); ?>">
                        <button class="btn btn-secondary me-2" type="submit" title="Buscar"><i class="bi bi-search"></i></button>
                        <a href="<?php echo e(url('/usuario/create')); ?>" class="btn btn-primary" title="Nuevo" style="text-decoration: none"><i class="bi bi-plus-lg"></i></a>
                    </form>
                </div>
            </div>
        </div>
        <div class="card-body">
            <table class="table table-condensed table-striped table-sm">
                <thead class="table-primary">
                    <tr>
                        <th><div align="center">ID</div></th>
                        <th>Nick</th>
                        <th>Nombre</th>
                        <th>Estado</th>
                        <th><div align="center">Acciones</div></th>
                    </tr>                    
                </thead>
                <tbody>
                    <?php $__currentLoopData = $usuarios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usuario): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td width=10% align="center"><?php echo e($usuario->idusuario); ?></td>
                            <td><?php echo e($usuario->nick); ?></td>
                            <td><?php echo e($usuario->nombre); ?></td>
                            <td>
                                <?php if($usuario->estado == 'ACTIVO' ): ?>
                                    ACTIVO
                                <?php else: ?>
                                    INACTIVO
                                <?php endif; ?>
                            </td>
                            <td width=15% align="center"> 
                                <a href="<?php echo e(url('/usuario/'.$usuario->idusuario.'/edit')); ?>" class="btn btn-warning btn-sm" title="Editar" style="cursor: pointer">
                                    <i class="bi bi-pencil-fill"></i>
                                </a>  
                                <a href="<?php echo e(url('/usuario/cambiarpass/'.$usuario->idusuario)); ?>" class="btn btn-warning btn-sm" title="Cambiar contraseña" style="cursor: pointer">
                                    <i class="bi bi-fingerprint"></i>
                                </a>
                                <a href="<?php echo e(url('/usuario/perfiles/'.$usuario->idusuario)); ?>" class="btn btn-warning btn-sm" title="Perfiles" style="cursor: pointer">
                                    <i class="bi bi-person-lines-fill"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table> 
            <?php echo $usuarios->links(); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/contapy/resources/views/usuario/index.blade.php ENDPATH**/ ?>