<?php $__env->startSection('contenido'); ?>
    <?php if(Session::has('mensaje')): ?>
        <div class="alert alert-success alert-dismissible fade show mb-2 mt-2" role="alert">
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            <strong>Ok. </strong><?php echo e(Session::get('mensaje')); ?>

        </div>
    <?php endif; ?>
    <div class="card mb-2">
        <div class="card-header">
            <div class="navbar">
                <div class="col-md-6" align="left">
                    <h4>Lista de Proveedores</h4>
                </div>
                <div class="col-md-4">
                    <form class="d-flex" role="search">
                        <input name="texto" autocomplete="off" class="form-control me-2" type="search" placeholder="Datos para buscar" aria-label="Buscar" value="<?php echo e($texto); ?>">
                        <button class="btn btn-secondary me-2" type="submit" title="Buscar"><i class="bi bi-search"></i></button>
                        <a href="<?php echo e(url('/proveedor/create')); ?>" class="btn btn-primary" title="Nuevo" style="text-decoration: none"><i class="bi bi-plus-lg"></i></a>
                    </form>
                </div>
            </div>
        </div>
        <div class="card-body">
            <table class="table table-sm table-condensed table-striped table-bordered">
                <thead class="table-primary">
                    
                    <th>Ruc</th>
                    <th>Denominación</th>
                    <th>Cuenta</th>
                    <th>Dirección</th>
                    <th>Teléfono</th>
                    <th width="7%"><div align="center">Estado</div></th>
                    <th width="5%"><div align="center">Acciones</div></th>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $proveedores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $proveedor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            
                            <td><?php echo e($proveedor->ruc); ?></td>
                            <td><?php echo e($proveedor->denominacion); ?></td>
                            <td><?php echo e($proveedor->cuenta); ?></td>
                            <td><?php echo e($proveedor->direccion); ?></td>
                            <td><?php echo e($proveedor->telefono); ?></td>
                            <td align="center">
                                <?php if($proveedor->estado == 'ACTIVO' ): ?>
                                    ACTIVO
                                <?php else: ?>
                                    INACTIVO
                                <?php endif; ?>
                            </td>
                            <td width=8% align="center">
                                <a href="<?php echo e(url('/proveedor/'.$proveedor->idproveedor.'/edit')); ?>" class="btn btn-warning btn-sm" title="Editar">
                                    <i class="bi bi-pencil-fill" style="cursor: pointer"></i>
                                </a> 
                            </td>   
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table> 
            <?php echo $proveedores->links(); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /opt/lampp/htdocs/contapy/resources/views/proveedor/index.blade.php ENDPATH**/ ?>